package cn.schoolwow.data.thread.work.reduce;

import cn.schoolwow.data.thread.work.AbstractDataThreadWork;
import cn.schoolwow.data.thread.work.map.MapWorkResult;

public class ReduceDataThreadWork extends AbstractDataThreadWork<ReduceDataThreadWork> {

    public ReduceDataThreadWork(String name) {
        super(name);
    }

    @Override
    protected ReduceDataThreadWork self() {
        return this;
    }

    /**分散任务结果*/
    public ReduceDataThreadWork mapWorkResult(MapWorkResult mapWorkResult){
        workFlow.putContextData("mapWorkResult", mapWorkResult);
        return this;
    }

    /**合并函数*/
    public ReduceDataThreadWork reduceDataThreadHandler(ReduceDataThreadHandler reduceDataThreadHandler){
        workFlow.putContextData("reduceDataThreadHandler", reduceDataThreadHandler);
        return this;
    }

    /**合并完成后是否删除文件*/
    public ReduceDataThreadWork deleteFile(boolean deleteFile){
        workFlow.putContextData("deleteFile", deleteFile);
        return this;
    }

}
