/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.data.thread;

import cn.schoolwow.data.thread.config.QuickDataThreadConfig;
import cn.schoolwow.data.thread.domain.DataThreadProgress;
import cn.schoolwow.data.thread.flow.handler.DataThreadBeforeAfterHandler;
import cn.schoolwow.data.thread.flow.work.ExecuteIntervalWorkFlow;
import cn.schoolwow.data.thread.flow.work.ExecuteLoopWorkFlow;
import cn.schoolwow.data.thread.flow.work.ExecuteMapWorkFlow;
import cn.schoolwow.data.thread.flow.work.ExecuteReduceWorkFlow;
import cn.schoolwow.data.thread.flow.work.ExecuteSingleWorkFlow;
import cn.schoolwow.data.thread.flow.work.map.GetMapFileFlow;
import cn.schoolwow.data.thread.work.interval.IntervalDataThreadWork;
import cn.schoolwow.data.thread.work.loop.LoopDataThreadWork;
import cn.schoolwow.data.thread.work.map.MapDataThreadWork;
import cn.schoolwow.data.thread.work.map.MapWorkResult;
import cn.schoolwow.data.thread.work.reduce.ReduceDataThreadWork;
import cn.schoolwow.data.thread.work.single.SingleDataThreadWork;
import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.listener.BeforeAfterFlowHandler;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class QuickDataThread {
    private QuickFlow dataThreadFlow = QuickFlow.newInstance();
    private QuickDataThreadConfig quickDataThreadConfig = new QuickDataThreadConfig(this.dataThreadFlow);

    public static QuickDataThread newInstance() {
        return new QuickDataThread();
    }

    public QuickDataThreadConfig config() {
        return this.quickDataThreadConfig;
    }

    public List<DataThreadProgress> getDataThreadProgressList() {
        List dataThreadProgressList = (List)this.dataThreadFlow.getContextData("progressList");
        return dataThreadProgressList;
    }

    public void interruptDataThread(long id) {
        List<DataThreadProgress> dataThreadProgressList = this.getDataThreadProgressList();
        for (DataThreadProgress dataThreadProgress : dataThreadProgressList) {
            if (dataThreadProgress.id != id) continue;
            dataThreadProgress.status = "\u4e2d\u65ad\u7ed3\u675f";
            dataThreadProgress.threadPoolExecutor.shutdownNow();
        }
    }

    public void deleteDataThreadProgress(long id) {
        List<DataThreadProgress> dataThreadProgressList = this.getDataThreadProgressList();
        Iterator<DataThreadProgress> iterator = dataThreadProgressList.iterator();
        while (iterator.hasNext()) {
            DataThreadProgress dataThreadProgress = iterator.next();
            if (dataThreadProgress.id != id) continue;
            if (null != dataThreadProgress.endTime || null != dataThreadProgress.exception) {
                iterator.remove();
                continue;
            }
            throw new IllegalArgumentException("\u53ea\u5141\u8bb8\u5220\u9664\u4efb\u52a1\u6b63\u5e38\u7ed3\u675f\u6216\u8005\u5f02\u5e38\u7ed3\u675f\u7684\u6570\u636e\u7ebf\u7a0b!\u8fdb\u5ea6id:" + id);
        }
    }

    public void executeIntervalDataThreadWork(IntervalDataThreadWork intervalDataThreadWork) {
        QuickFlow workFlow = intervalDataThreadWork.getWorkFlow();
        workFlow.startFlow(new ExecuteIntervalWorkFlow()).beforeAfterFlowHandler((BeforeAfterFlowHandler)new DataThreadBeforeAfterHandler()).putCurrentCompositeFlowData("dataThreadFlow", (Object)this.dataThreadFlow).execute();
    }

    public void executeLoopDataThreadWork(LoopDataThreadWork loopDataThreadWork) {
        QuickFlow workFlow = loopDataThreadWork.getWorkFlow();
        workFlow.startFlow(new ExecuteLoopWorkFlow()).beforeAfterFlowHandler((BeforeAfterFlowHandler)new DataThreadBeforeAfterHandler()).putCurrentCompositeFlowData("dataThreadFlow", (Object)this.dataThreadFlow).execute();
    }

    public void executeSingleDataThreadWork(SingleDataThreadWork singleDataThreadWork) {
        QuickFlow workFlow = singleDataThreadWork.getWorkFlow();
        workFlow.startFlow(new ExecuteSingleWorkFlow()).beforeAfterFlowHandler((BeforeAfterFlowHandler)new DataThreadBeforeAfterHandler()).putCurrentCompositeFlowData("dataThreadFlow", (Object)this.dataThreadFlow).execute();
    }

    public boolean existMapFile(String name, String id) {
        File file = (File)this.dataThreadFlow.startFlow((BusinessFlow)new GetMapFileFlow()).putCurrentCompositeFlowData("workName", (Object)name).putCurrentCompositeFlowData("id", (Object)id).execute().checkData("mapFile");
        return file.exists();
    }

    public String getMapFileContent(String name, String id) throws IOException {
        File file = (File)this.dataThreadFlow.startFlow((BusinessFlow)new GetMapFileFlow()).putCurrentCompositeFlowData("workName", (Object)name).putCurrentCompositeFlowData("id", (Object)id).execute().checkData("mapFile");
        return FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
    }

    public MapWorkResult executeMapDataThreadWork(MapDataThreadWork mapDataThreadWork) {
        QuickFlow workFlow = mapDataThreadWork.getWorkFlow();
        FlowContext flowContext = workFlow.startFlow(new ExecuteMapWorkFlow()).beforeAfterFlowHandler((BeforeAfterFlowHandler)new DataThreadBeforeAfterHandler()).putCurrentCompositeFlowData("dataThreadFlow", (Object)this.dataThreadFlow).execute();
        MapWorkResult mapWorkResult = new MapWorkResult();
        mapWorkResult.name = (String)flowContext.checkData("name");
        mapWorkResult.idList = (List)flowContext.getData("idList");
        return mapWorkResult;
    }

    public void executeReduceMapDataThreadWork(ReduceDataThreadWork reduceDataThreadWork) throws IOException {
        QuickFlow workFlow = reduceDataThreadWork.getWorkFlow();
        FlowContext flowContext = workFlow.startFlow(new ExecuteReduceWorkFlow()).beforeAfterFlowHandler((BeforeAfterFlowHandler)new DataThreadBeforeAfterHandler()).putCurrentCompositeFlowData("dataThreadFlow", (Object)this.dataThreadFlow).execute();
        boolean deleteFile = (Boolean)flowContext.getData("deleteFile", (Object)true);
        if (deleteFile) {
            String mapDirectory = (String)flowContext.checkData("mapDirectory");
            FileUtils.forceDelete((File)new File(mapDirectory));
        }
    }
}

