/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.data.thread.flow.common;

import cn.schoolwow.data.thread.domain.DataThreadProgress;
import cn.schoolwow.data.thread.listener.ProgressListener;
import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;

public class BeforeExecuteFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        this.setDataThreadContextData(flowContext);
        this.setThreadPool(flowContext);
        this.setProcessListener(flowContext);
        this.setWaitFor(flowContext);
        this.setRecordProgress(flowContext);
        this.addToProgressList(flowContext);
        flowContext.putTemporaryData("threadExceptionMap", new HashMap());
        flowContext.putTemporaryData("progress", (Object)new AtomicInteger(1));
    }

    public String name() {
        return "\u6267\u884c\u4efb\u52a1\u4e4b\u524d";
    }

    private void setDataThreadContextData(FlowContext flowContext) {
        QuickFlow dataThreadFlow = (QuickFlow)flowContext.checkData("dataThreadFlow");
        Map contextDataMap = dataThreadFlow.getContextDataMap();
        for (Map.Entry entry : contextDataMap.entrySet()) {
            flowContext.putContextData((String)entry.getKey(), entry.getValue());
        }
    }

    private void setThreadPool(FlowContext flowContext) {
        Integer threadCount = (Integer)flowContext.getData("workThreadCount");
        if (null == threadCount) {
            threadCount = (Integer)flowContext.getData("threadCount");
        }
        if (null == threadCount) {
            threadCount = Runtime.getRuntime().availableProcessors() * 2;
        }
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(threadCount);
        flowContext.putCurrentCompositeFlowData("threadPoolExecutor", (Object)threadPoolExecutor);
    }

    private void setProcessListener(FlowContext flowContext) {
        ProgressListener progressListener = (ProgressListener)flowContext.getData("workProgressListener");
        if (null == progressListener) {
            progressListener = (ProgressListener)flowContext.getData("progressListener");
        }
        flowContext.putCurrentCompositeFlowData("progressListener", (Object)progressListener);
    }

    private void setWaitFor(FlowContext flowContext) {
        Boolean waitFor = (Boolean)flowContext.getData("workWaitFor");
        if (null == waitFor) {
            waitFor = (Boolean)flowContext.getData("waitFor");
        }
        flowContext.putCurrentCompositeFlowData("waitFor", (Object)waitFor);
    }

    private void setRecordProgress(FlowContext flowContext) {
        Boolean recordProgress = (Boolean)flowContext.getData("workRecordProgress");
        if (null == recordProgress) {
            recordProgress = (Boolean)flowContext.getData("recordProgress");
        }
        flowContext.putCurrentCompositeFlowData("recordProgress", (Object)recordProgress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToProgressList(FlowContext flowContext) {
        List dataThreadProgressList = (List)flowContext.getData("progressList", new ArrayList());
        String name = (String)flowContext.checkData("name");
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)flowContext.checkData("threadPoolExecutor");
        boolean recordProgress = (Boolean)flowContext.checkData("recordProgress");
        DataThreadProgress dataThreadProgress = new DataThreadProgress();
        dataThreadProgress.id = System.nanoTime();
        dataThreadProgress.name = name;
        dataThreadProgress.startTime = new Timestamp(System.currentTimeMillis());
        dataThreadProgress.threadPoolExecutor = threadPoolExecutor;
        if (recordProgress) {
            List list = dataThreadProgressList;
            synchronized (list) {
                dataThreadProgressList.add(dataThreadProgress);
            }
        }
        flowContext.putTemporaryData("dataThreadProgress", (Object)dataThreadProgress);
    }
}

