/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.data.thread.flow.handler;

import cn.schoolwow.data.thread.domain.DataThreadProgress;
import cn.schoolwow.data.thread.listener.ProgressListener;
import cn.schoolwow.data.thread.util.QuickDataThreadUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.FunctionFlow;
import cn.schoolwow.quickflow.listener.TryCatchFinallyHandler;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class WorkTryCatchFinallyHandler
implements TryCatchFinallyHandler {
    public void handleTry(FlowContext flowContext) throws Exception {
        FunctionFlow handleFunction = (FunctionFlow)flowContext.checkData("handleFunction");
        handleFunction.executeFunction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleException(FlowContext flowContext, Exception e) {
        Map threadExceptionMap;
        Map map = threadExceptionMap = (Map)flowContext.getData("threadExceptionMap", new HashMap());
        synchronized (map) {
            threadExceptionMap.put(Thread.currentThread().getId(), e);
        }
        DataThreadProgress dataThreadProgress = (DataThreadProgress)flowContext.checkData("dataThreadProgress");
        dataThreadProgress.exception = QuickDataThreadUtil.formatThreadException(threadExceptionMap);
        dataThreadProgress.status = "\u5f02\u5e38\u7ed3\u675f";
    }

    public void handleFinally(FlowContext flowContext) {
        String name = (String)flowContext.checkData("name");
        AtomicInteger progress = (AtomicInteger)flowContext.checkData("progress");
        int delta = (Integer)flowContext.checkData("delta");
        ProgressListener progressListener = (ProgressListener)flowContext.getData("progressListener");
        DataThreadProgress dataThreadProgress = (DataThreadProgress)flowContext.checkData("dataThreadProgress");
        progress.getAndAdd(delta);
        if (null != progressListener) {
            progressListener.progress(name, progress.get(), dataThreadProgress.total);
        }
        dataThreadProgress.current = progress.get();
        dataThreadProgress.percent = dataThreadProgress.current * 100 / dataThreadProgress.total;
        if (dataThreadProgress.percent == 100 && null == dataThreadProgress.exception) {
            dataThreadProgress.endTime = new Timestamp(System.currentTimeMillis());
            dataThreadProgress.status = "\u6b63\u5e38\u7ed3\u675f";
        }
    }

    public String name() {
        return "\u591a\u7ebf\u7a0b\u4efb\u52a1tryCatchFinally\u5904\u7406\u5668";
    }
}

