/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.data.thread.flow.work;

import cn.schoolwow.data.thread.domain.DataThreadProgress;
import cn.schoolwow.data.thread.flow.handler.WorkTryCatchFinallyHandler;
import cn.schoolwow.data.thread.work.interval.IntervalDataThreadHandler;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.flow.FunctionFlow;
import cn.schoolwow.quickflow.listener.TryCatchFinallyHandler;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;

public class ExecuteIntervalWorkFlow<T>
implements BusinessFlow {
    public void executeBusinessFlow(final FlowContext flowContext) throws Exception {
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)flowContext.checkData("threadPoolExecutor");
        final List list = (List)flowContext.checkData("list");
        int interval = (Integer)flowContext.checkData("interval");
        if (interval <= 0) {
            throw new IllegalArgumentException("\u4efb\u52a1\u95f4\u9694\u5fc5\u987b\u5927\u4e8e0");
        }
        final IntervalDataThreadHandler intervalDataThreadHandler = (IntervalDataThreadHandler)flowContext.checkData("intervalDataThreadHandler");
        DataThreadProgress dataThreadProgress = (DataThreadProgress)flowContext.checkData("dataThreadProgress");
        int segment = list.size() / interval + (list.size() % interval > 0 ? 1 : 0);
        dataThreadProgress.total = list.size();
        dataThreadProgress.type = "Interval";
        StringBuilder descriptionBuilder = new StringBuilder("\u5206\u6bb5\u5217\u8868:");
        for (int i = 0; i < segment; ++i) {
            final int start = i * interval;
            final int end = Math.min((i + 1) * interval, list.size());
            descriptionBuilder.append("[" + start + "-" + end + "]");
            threadPoolExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    flowContext.startFlow("\u6267\u884cInterval\u5355\u4e2a\u7ebf\u7a0b\u4efb\u52a1").tryCatchFinallyHandler((TryCatchFinallyHandler)new WorkTryCatchFinallyHandler()).putThreadLocalData("delta", (Object)(end - start)).putThreadLocalData("handleFunction", (Object)new FunctionFlow(){

                        public void executeFunction() throws Exception {
                            intervalDataThreadHandler.handleIntervalList(list, start, end);
                        }
                    }).execute();
                }
            });
        }
        dataThreadProgress.description = descriptionBuilder.toString();
    }

    public String name() {
        return "\u6267\u884cInterval\u7c7b\u578b\u4efb\u52a1";
    }
}

