package cn.schoolwow.data.thread;

import cn.schoolwow.data.thread.domain.progress.DataThreadProgress;
import cn.schoolwow.data.thread.domain.progress.ProgressListener;
import cn.schoolwow.data.thread.module.parent.domain.QuickDataThreadConfig;
import cn.schoolwow.data.thread.module.parent.domain.QuickDataThreadInvocationHandler;
import cn.schoolwow.data.thread.module.producerConsumer.domain.ConsumerContext;
import cn.schoolwow.data.thread.module.producerConsumer.domain.RegisterConsumerRequest;
import cn.schoolwow.data.thread.module.producerConsumer.flow.InitialConsumerThreadFlow;
import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.QuickFlowBuilder;
import org.apache.commons.lang3.Validate;

import java.io.IOException;
import java.lang.reflect.Proxy;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public class QuickDataThreadBuilder {
    private QuickDataThreadConfig quickDataThreadConfig = new QuickDataThreadConfig();

    public static QuickDataThreadBuilder newInstance(){
        return new QuickDataThreadBuilder();
    }

    public QuickDataThreadBuilder() {
    }

    /**指定工作目录*/
    public QuickDataThreadBuilder workDir(String workDir) throws IOException {
        Files.createDirectories(Paths.get(workDir));
        quickDataThreadConfig.workDir = workDir;
        return this;
    }

    /**监听进度*/
    public QuickDataThreadBuilder progressListener(ProgressListener progressListener) {
        quickDataThreadConfig.progressListener = progressListener;
        return this;
    }

    /**线程个数*/
    public QuickDataThreadBuilder threadCount(int threadCount) {
        quickDataThreadConfig.threadCount = threadCount;
        return this;
    }

    /**等待超时时间*/
    public QuickDataThreadBuilder timeout(Integer timeout, TimeUnit timeoutUnit) {
        quickDataThreadConfig.timeout = timeout;
        quickDataThreadConfig.timeoutUnit = timeoutUnit;
        return this;
    }

    /**是否等待线程执行完毕*/
    public QuickDataThreadBuilder waitFor(boolean waitFor) {
        quickDataThreadConfig.waitFor = waitFor;
        return this;
    }

    /**是否记录到进度列表*/
    public QuickDataThreadBuilder recordProgress(boolean recordProgress) {
        quickDataThreadConfig.recordProgress = recordProgress;
        return this;
    }

    /**注册消费者*/
    public <T> QuickDataThreadBuilder registerConsumer(RegisterConsumerRequest<T> registerConsumerRequest) {
        Validate.notNull(registerConsumerRequest.messageType, "未设置消息类型");
        Validate.notNull(registerConsumerRequest.messageConsumer, "未设置消息处理器");

        ConsumerContext consumerContext = new ConsumerContext();
        consumerContext.registerConsumerRequest = registerConsumerRequest;
        consumerContext.messageTypeClassName = registerConsumerRequest.messageType.getName();

        quickDataThreadConfig.consumerContextMap.put(consumerContext.messageTypeClassName, consumerContext);
        return this;
    }

    public QuickDataThread build(){
        QuickFlow quickFlow = QuickFlowBuilder.newInstance()
                .putContextData("dataThreadProgressList", new ArrayList<DataThreadProgress>())
                .putContextData("quickDataThreadConfig", quickDataThreadConfig);
        quickFlow.executeFlow(new InitialConsumerThreadFlow());

        QuickDataThreadInvocationHandler quickDataThreadInvocationHandler = new QuickDataThreadInvocationHandler(quickFlow);
        QuickDataThread quickDataThread = (QuickDataThread) Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(),
                new Class<?>[]{QuickDataThread.class}, quickDataThreadInvocationHandler);
        return quickDataThread;
    }
}
