package cn.schoolwow.data.thread.module.execute.common.after.flow;

import cn.schoolwow.data.thread.domain.excecption.ThreadException;
import cn.schoolwow.data.thread.module.execute.common.handler.WorkThreadTryCatchFinallyHandler;
import cn.schoolwow.data.thread.module.parent.domain.QuickDataThreadConfig;
import cn.schoolwow.data.thread.util.QuickDataThreadUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.flow.FunctionFlow;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;

public class AfterExecuteFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor) flowContext.checkData("threadPoolExecutor");
        QuickDataThreadConfig quickDataThreadConfig = (QuickDataThreadConfig) flowContext.checkData("quickDataThreadConfig");
        Map<Long,Exception> threadExceptionMap = (Map<Long, Exception>) flowContext.getData("threadExceptionMap", new HashMap<>());
        boolean waitFor = (boolean) flowContext.checkData("waitFor");
        List<BusinessFlow> dataThreadWorkList = (List<BusinessFlow>) flowContext.checkData("dataThreadWorkList");

        if(waitFor){
            CountDownLatch countDownLatch = new CountDownLatch(dataThreadWorkList.size());
            for(BusinessFlow businessFlow:dataThreadWorkList){
                threadPoolExecutor.execute(()->{
                    flowContext.startFlow(businessFlow)
                            .next(new BusinessFlow() {
                                @Override
                                public void executeBusinessFlow(FlowContext flowContext) throws Exception {
                                    FunctionFlow handleFunction = (FunctionFlow) flowContext.checkData("handleFunction");
                                    try {
                                        handleFunction.executeFunction(flowContext);
                                    }catch (Exception e){
                                        e.printStackTrace();
                                    }
                                }

                                @Override
                                public String name() {
                                    return "执行实际任务";
                                }
                            })
                            .tryCatchFinallyHandler(new WorkThreadTryCatchFinallyHandler())
                            .printTrace(false)
                            .execute();
                    countDownLatch.countDown();
                });
            }

            boolean timeoutFlag = countDownLatch.await(quickDataThreadConfig.timeout, quickDataThreadConfig.timeoutUnit);
            flowContext.putData("等待线程池结束是否超时", timeoutFlag);

            if(!threadExceptionMap.isEmpty()){
                throw new ThreadException(QuickDataThreadUtil.formatThreadException(threadExceptionMap), threadExceptionMap);
            }
        }
    }

    @Override
    public String name() {
        return "执行任务之后";
    }

}
