package cn.schoolwow.data.thread.module.execute.common.before.flow;

import cn.schoolwow.data.thread.domain.execute.parent.DataThreadWorkRequest;
import cn.schoolwow.data.thread.domain.progress.DataThreadProgress;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;

public class SetDataThreadProgressFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        DataThreadWorkRequest dataThreadWorkRequest = (DataThreadWorkRequest) flowContext.checkData("dataThreadWorkRequest");
        List<DataThreadProgress> dataThreadProgressList = (List<DataThreadProgress>) flowContext.getData("dataThreadProgressList");
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor) flowContext.checkData("threadPoolExecutor");
        boolean recordProgress = (boolean) flowContext.checkData("recordProgress");

        AtomicInteger progress = new AtomicInteger(0);
        flowContext.putTemporaryData("progress", progress);

        DataThreadProgress dataThreadProgress = new DataThreadProgress();
        dataThreadProgress.id = System.nanoTime();
        dataThreadProgress.name = dataThreadWorkRequest.name;
        dataThreadProgress.startTime = new Timestamp(System.currentTimeMillis());
        dataThreadProgress.threadPoolExecutor = threadPoolExecutor;
        if(recordProgress){
            synchronized (dataThreadProgressList){
                dataThreadProgressList.add(dataThreadProgress);
            }
        }
        flowContext.putTemporaryData("dataThreadProgress", dataThreadProgress);
    }

    @Override
    public String name() {
        return "设置线程执行进度对象";
    }
}
