package cn.schoolwow.data.thread.module.execute.common.before.flow;

import cn.schoolwow.data.thread.domain.execute.parent.DataThreadWorkRequest;
import cn.schoolwow.data.thread.domain.progress.ProgressListener;
import cn.schoolwow.data.thread.module.parent.domain.QuickDataThreadConfig;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class SetProgressListenerFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        DataThreadWorkRequest dataThreadWorkRequest = (DataThreadWorkRequest) flowContext.checkData("dataThreadWorkRequest");
        QuickDataThreadConfig quickDataThreadConfig = (QuickDataThreadConfig) flowContext.checkData("quickDataThreadConfig");

        ProgressListener progressListener = null==dataThreadWorkRequest.progressListener?quickDataThreadConfig.progressListener:dataThreadWorkRequest.progressListener;
        flowContext.putTemporaryData("progressListener", progressListener);
    }

    @Override
    public String name() {
        return "设置进度监听器";
    }
}
