package cn.schoolwow.data.thread.module.execute.common.before.flow;

import cn.schoolwow.data.thread.domain.execute.parent.DataThreadWorkRequest;
import cn.schoolwow.data.thread.module.parent.domain.QuickDataThreadConfig;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class SetRecordProgressFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        DataThreadWorkRequest dataThreadWorkRequest = (DataThreadWorkRequest) flowContext.checkData("dataThreadWorkRequest");
        QuickDataThreadConfig quickDataThreadConfig = (QuickDataThreadConfig) flowContext.checkData("quickDataThreadConfig");

        Boolean recordProgress = null==dataThreadWorkRequest.recordProgress?quickDataThreadConfig.recordProgress:dataThreadWorkRequest.recordProgress;
        flowContext.putTemporaryData("recordProgress", recordProgress);
    }

    @Override
    public String name() {
        return "设置是否记录到进度列表中";
    }
}
