package cn.schoolwow.data.thread.module.execute.common.before.flow;

import cn.schoolwow.data.thread.domain.execute.parent.DataThreadWorkRequest;
import cn.schoolwow.data.thread.module.parent.domain.QuickDataThreadConfig;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;

public class SetThreadPoolFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        DataThreadWorkRequest dataThreadWorkRequest = (DataThreadWorkRequest) flowContext.checkData("dataThreadWorkRequest");
        QuickDataThreadConfig quickDataThreadConfig = (QuickDataThreadConfig) flowContext.checkData("quickDataThreadConfig");

        int threadCount = null==dataThreadWorkRequest.threadCount?quickDataThreadConfig.threadCount:dataThreadWorkRequest.threadCount;
        flowContext.putTemporaryData("threadCount", threadCount);

        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor) Executors.newFixedThreadPool(threadCount);
        flowContext.putTemporaryData("threadPoolExecutor", threadPoolExecutor);

        List<BusinessFlow> dataThreadWorkList = new ArrayList<>();
        flowContext.putTemporaryData("dataThreadWorkList", dataThreadWorkList);
    }

    @Override
    public String name() {
        return "设置线程池";
    }
}
