package cn.schoolwow.data.thread.module.execute.common.before.flow;

import cn.schoolwow.data.thread.domain.execute.parent.DataThreadWorkRequest;
import cn.schoolwow.data.thread.module.parent.domain.QuickDataThreadConfig;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class SetWaitForFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        DataThreadWorkRequest dataThreadWorkRequest = (DataThreadWorkRequest) flowContext.checkData("dataThreadWorkRequest");
        QuickDataThreadConfig quickDataThreadConfig = (QuickDataThreadConfig) flowContext.checkData("quickDataThreadConfig");

        Boolean waitFor = null==dataThreadWorkRequest.waitFor?quickDataThreadConfig.waitFor:dataThreadWorkRequest.waitFor;
        flowContext.putTemporaryData("waitFor", waitFor);
    }

    @Override
    public String name() {
        return "设置是否等待线程执行完毕";
    }
}
