package cn.schoolwow.data.thread.module.execute.common.before.service;

import cn.schoolwow.data.thread.module.execute.common.before.flow.*;
import cn.schoolwow.quickflow.QuickFlowExecutor;
import cn.schoolwow.quickflow.flow.CompositeBusinessFlow;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class BeforeExecuteCompositeBusiness implements CompositeBusinessFlow {
    @Override
    public void executeCompositeBusiness(QuickFlowExecutor quickFlowExecutor) {
        quickFlowExecutor.next(new CheckDataThreadWorkRequestFlow())
                .next(new SetThreadPoolFlow())
                .next(new SetProgressListenerFlow())
                .next(new SetWaitForFlow())
                .next(new SetRecordProgressFlow())
                .next(new SetDataThreadProgressFlow())
                .putTemporaryData("threadExceptionMap", new HashMap<>())
                .putTemporaryData("progress", new AtomicInteger(1));
    }

    @Override
    public String name() {
        return "执行线程任务之前";
    }
}
