package cn.schoolwow.data.thread.module.execute.common.handler;

import cn.schoolwow.data.thread.domain.execute.parent.DataThreadWorkRequest;
import cn.schoolwow.data.thread.domain.progress.DataThreadProgress;
import cn.schoolwow.data.thread.domain.progress.ProgressListener;
import cn.schoolwow.data.thread.util.QuickDataThreadUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.listener.TryCatchFinallyHandler;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class WorkThreadTryCatchFinallyHandler implements TryCatchFinallyHandler {
    @Override
    public void handleTryStart(FlowContext flowContext) throws Exception {
    }

    @Override
    public void handleTryEnd(FlowContext flowContext) throws Exception {

    }

    @Override
    public void handleException(FlowContext flowContext, Exception e) {
        e.printStackTrace();

        Map<Long,Exception> threadExceptionMap = (Map<Long, Exception>) flowContext.getData("threadExceptionMap", new HashMap<>());
        synchronized (threadExceptionMap){
            threadExceptionMap.put(Thread.currentThread().getId(), e);
        }
        DataThreadProgress dataThreadProgress = (DataThreadProgress) flowContext.checkData("dataThreadProgress");
        dataThreadProgress.exception = QuickDataThreadUtil.formatThreadException(threadExceptionMap);
        dataThreadProgress.status = "异常结束";
    }

    @Override
    public void handleFinally(FlowContext flowContext) {
        DataThreadWorkRequest dataThreadWorkRequest = (DataThreadWorkRequest) flowContext.checkData("dataThreadWorkRequest");
        ProgressListener progressListener = (ProgressListener) flowContext.getData("progressListener");
        DataThreadProgress dataThreadProgress = (DataThreadProgress) flowContext.checkData("dataThreadProgress");
        AtomicInteger progress = (AtomicInteger) flowContext.checkData("progress");
        int delta = (int) flowContext.checkData("delta");

        progress.getAndAdd(delta);
        if(null!=progressListener){
            progressListener.progress(dataThreadWorkRequest.type, dataThreadWorkRequest.name, progress.get(), dataThreadProgress.total);
        }
        dataThreadProgress.current = progress.get();
        dataThreadProgress.percent = dataThreadProgress.current*100/dataThreadProgress.total;
        if(dataThreadProgress.percent==100&&null==dataThreadProgress.exception){
            dataThreadProgress.endTime = new Timestamp(System.currentTimeMillis());
            dataThreadProgress.status = "正常结束";
        }
    }

    @Override
    public String name() {
        return "单个线程任务tryCatchFinally处理器";
    }
}
