package cn.schoolwow.data.thread.module.execute.kit;

import cn.schoolwow.data.thread.domain.execute.type.interval.IntervalDataThreadWorkRequest;
import cn.schoolwow.data.thread.domain.execute.type.loop.LoopDataThreadWorkRequest;
import cn.schoolwow.data.thread.domain.execute.type.map.MapDataThreadWorkRequest;
import cn.schoolwow.data.thread.domain.execute.type.map.MapWorkResult;
import cn.schoolwow.data.thread.domain.execute.type.reduce.ReduceDataThreadWorkRequest;
import cn.schoolwow.data.thread.domain.execute.type.single.SingleDataThreadWorkRequest;

import java.io.IOException;

public interface DataThreadExecute {
    /**
     * 执行Interval类型任务
     * */
    <T> void executeIntervalDataThreadWork(IntervalDataThreadWorkRequest<T> intervalDataThreadWorkRequest);

    /**
     * 执行Loop类型任务
     * */
    void executeLoopDataThreadWork(LoopDataThreadWorkRequest loopDataThreadWorkRequest);

    /**
     * 执行Single类型任务
     * */
    <T> void executeSingleDataThreadWork(SingleDataThreadWorkRequest<T> singleDataThreadWorkRequest);

    /**
     * 获取mapFile文件内容
     * */
    String getMapFileContent(String name, String id) throws IOException;

    /**
     * 执行Map类型任务
     * */
    MapWorkResult executeMapDataThreadWork(MapDataThreadWorkRequest mapDataThreadWorkRequest);

    /**
     * 执行Reduce类型任务
     * */
    void executeReduceMapDataThreadWork(ReduceDataThreadWorkRequest reduceDataThreadWorkRequest) throws IOException;
}
