package cn.schoolwow.data.thread.module.execute.kit;

import cn.schoolwow.data.thread.domain.execute.parent.DataThreadWorkRequest;
import cn.schoolwow.data.thread.domain.execute.type.interval.IntervalDataThreadWorkRequest;
import cn.schoolwow.data.thread.domain.execute.type.loop.LoopDataThreadWorkRequest;
import cn.schoolwow.data.thread.domain.execute.type.map.MapDataThreadWorkRequest;
import cn.schoolwow.data.thread.domain.execute.type.map.MapWorkResult;
import cn.schoolwow.data.thread.domain.execute.type.reduce.ReduceDataThreadWorkRequest;
import cn.schoolwow.data.thread.domain.execute.type.single.SingleDataThreadWorkRequest;
import cn.schoolwow.data.thread.module.execute.type.flow.map.GetMapFileFlow;
import cn.schoolwow.data.thread.module.execute.type.service.*;
import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import org.apache.commons.io.FileUtils;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class DataThreadExecuteImpl implements DataThreadExecute{
    private QuickFlow quickFlow;

    public DataThreadExecuteImpl(QuickFlow quickFlow) {
        this.quickFlow = quickFlow;
    }

    @Override
    public <T> void executeIntervalDataThreadWork(IntervalDataThreadWorkRequest<T> intervalDataThreadWorkRequest) {
        quickFlow.startFlow(new ExecuteIntervalDataThreadWorkCompositeBusiness<T>())
                .putCurrentCompositeFlowData("intervalDataThreadWorkRequest", intervalDataThreadWorkRequest)
                .putCurrentCompositeFlowData("dataThreadWorkRequest", intervalDataThreadWorkRequest)
                .execute();
    }

    @Override
    public void executeLoopDataThreadWork(LoopDataThreadWorkRequest loopDataThreadWorkRequest) {
        quickFlow.startFlow(new ExecuteLoopDataThreadWorkCompositeBusiness())
                .putCurrentCompositeFlowData("loopDataThreadWorkRequest", loopDataThreadWorkRequest)
                .putCurrentCompositeFlowData("dataThreadWorkRequest", loopDataThreadWorkRequest)
                .execute();
    }

    @Override
    public <T> void executeSingleDataThreadWork(SingleDataThreadWorkRequest<T> singleDataThreadWorkRequest) {
        quickFlow.startFlow(new ExecuteSingleDataThreadWorkCompositeBusiness<T>())
                .putCurrentCompositeFlowData("singleDataThreadWorkRequest", singleDataThreadWorkRequest)
                .putCurrentCompositeFlowData("dataThreadWorkRequest", singleDataThreadWorkRequest)
                .execute();
    }

    @Override
    public String getMapFileContent(String name, String id) throws IOException {
        DataThreadWorkRequest dataThreadWorkRequest = new DataThreadWorkRequest("Map", name);
        FlowContext flowContext = quickFlow.startFlow(new GetMapFileFlow())
                .putCurrentCompositeFlowData("dataThreadWorkRequest", dataThreadWorkRequest)
                .putCurrentCompositeFlowData("id", id)
                .execute();
        File file = (File) flowContext.checkData("mapFile");
        return FileUtils.readFileToString(file, StandardCharsets.UTF_8);
    }

    @Override
    public MapWorkResult executeMapDataThreadWork(MapDataThreadWorkRequest mapDataThreadWorkRequest) {
        FlowContext flowContext = quickFlow.startFlow(new ExecuteMapDataThreadWorkCompositeBusiness())
                .putCurrentCompositeFlowData("mapDataThreadWorkRequest", mapDataThreadWorkRequest)
                .putCurrentCompositeFlowData("dataThreadWorkRequest", mapDataThreadWorkRequest)
                .execute();
        MapWorkResult mapWorkResult = (MapWorkResult) flowContext.checkData("mapWorkResult");
        return mapWorkResult;
    }

    @Override
    public void executeReduceMapDataThreadWork(ReduceDataThreadWorkRequest reduceDataThreadWorkRequest) throws IOException {
        FlowContext flowContext = quickFlow.startFlow(new ExecuteReduceDataThreadWorkCompositeBusiness())
                .putCurrentCompositeFlowData("reduceDataThreadWorkRequest", reduceDataThreadWorkRequest)
                .putCurrentCompositeFlowData("dataThreadWorkRequest", reduceDataThreadWorkRequest)
                .execute();
        //TODO 后续优化
        if(reduceDataThreadWorkRequest.deleteFile){
            String mapDirectory = (String) flowContext.checkData("mapDirectory");
            FileUtils.forceDelete(new File(mapDirectory));
        }
    }

}
