package cn.schoolwow.data.thread.module.execute.type.flow.interval;

import cn.schoolwow.data.thread.domain.execute.type.interval.IntervalDataThreadWorkRequest;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import org.apache.commons.lang3.Validate;

public class CheckIntervalDataThreadWorkRequestFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        IntervalDataThreadWorkRequest intervalDataThreadWorkRequest = (IntervalDataThreadWorkRequest) flowContext.checkData("intervalDataThreadWorkRequest");

        Validate.notNull(intervalDataThreadWorkRequest, "执行Interval类型请求参数不能为空");
        Validate.notNull(intervalDataThreadWorkRequest.list, "待处理列表不能为空");
        Validate.notEmpty(intervalDataThreadWorkRequest.list, "待处理列表不能为空");
        Validate.notNull(intervalDataThreadWorkRequest.intervalDataThreadHandler, "Interval类型处理器参数不能为空");
        Validate.isTrue(intervalDataThreadWorkRequest.interval>0, "任务间隔必须大于0");
    }

    @Override
    public String name() {
        return "检查Interval类型请求参数";
    }
}
