package cn.schoolwow.data.thread.module.execute.type.flow.interval;

import cn.schoolwow.data.thread.domain.execute.type.interval.IntervalDataThreadWorkRequest;
import cn.schoolwow.data.thread.domain.progress.DataThreadProgress;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.flow.FunctionFlow;

import java.util.List;

public class SetIntervalDataWorkThreadFlow<T> implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        IntervalDataThreadWorkRequest<T> intervalDataThreadWorkRequest = (IntervalDataThreadWorkRequest) flowContext.checkData("intervalDataThreadWorkRequest");
        DataThreadProgress dataThreadProgress = (DataThreadProgress) flowContext.checkData("dataThreadProgress");
        List<BusinessFlow> dataThreadWorkList = (List<BusinessFlow>) flowContext.getData("dataThreadWorkList");

        int segment = intervalDataThreadWorkRequest.list.size()/intervalDataThreadWorkRequest.interval
                +(intervalDataThreadWorkRequest.list.size()%intervalDataThreadWorkRequest.interval>0?1:0);
        dataThreadProgress.total = intervalDataThreadWorkRequest.list.size();
        dataThreadProgress.type = "Interval";

        StringBuilder descriptionBuilder = new StringBuilder("分段列表:");
        for(int i=0;i<segment;i++){
            int start = i*intervalDataThreadWorkRequest.interval;
            int end = Math.min((i+1)*intervalDataThreadWorkRequest.interval, intervalDataThreadWorkRequest.list.size());
            descriptionBuilder.append("["+start+"-"+end+"]");

            dataThreadWorkList.add(new BusinessFlow() {
                @Override
                public void executeBusinessFlow(FlowContext flowContext) throws Exception {
                    flowContext.putThreadLocalData("delta", end-start)
                            .putThreadLocalData("handleFunction", new FunctionFlow() {
                                @Override
                                public void executeFunction(FlowContext flowContext) throws Exception {
                                    intervalDataThreadWorkRequest.intervalDataThreadHandler.handleIntervalList(intervalDataThreadWorkRequest.list, start, end);
                                }
                            });
                }

                @Override
                public String name() {
                    return "单个Interval类型任务";
                }
            });
        }
        dataThreadProgress.description = descriptionBuilder.toString();
    }

    @Override
    public String name() {
        return "设置Interval类型任务线程";
    }

}
