package cn.schoolwow.data.thread.module.execute.type.flow.loop;

import cn.schoolwow.data.thread.domain.execute.type.loop.LoopDataThreadWorkRequest;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import org.apache.commons.lang3.Validate;

public class CheckLoopDataThreadWorkRequestFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        LoopDataThreadWorkRequest loopDataThreadWorkRequest = (LoopDataThreadWorkRequest) flowContext.checkData("loopDataThreadWorkRequest");

        Validate.notNull(loopDataThreadWorkRequest, "执行Loop类型请求参数不能为空");
        Validate.notNull(loopDataThreadWorkRequest.startIndex, "请指定开始下标");
        Validate.notNull(loopDataThreadWorkRequest.endIndex, "请指定结束下标");
        Validate.isTrue(loopDataThreadWorkRequest.startIndex<=loopDataThreadWorkRequest.endIndex, "开始下标必须小于等于结束下标");
        Validate.notNull(loopDataThreadWorkRequest.loopDataThreadHandler, "Loop类型处理器参数不能为空");
    }

    @Override
    public String name() {
        return "检查Loop类型请求参数";
    }
}
