package cn.schoolwow.data.thread.module.execute.type.flow.loop;

import cn.schoolwow.data.thread.domain.execute.type.loop.LoopDataThreadWorkRequest;
import cn.schoolwow.data.thread.domain.progress.DataThreadProgress;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.flow.FunctionFlow;

import java.util.List;

public class SetLoopDataThreadWorkFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        LoopDataThreadWorkRequest loopDataThreadWorkRequest = (LoopDataThreadWorkRequest) flowContext.checkData("loopDataThreadWorkRequest");
        DataThreadProgress dataThreadProgress = (DataThreadProgress) flowContext.checkData("dataThreadProgress");
        List<BusinessFlow> dataThreadWorkList = (List<BusinessFlow>) flowContext.getData("dataThreadWorkList");

        dataThreadProgress.total = loopDataThreadWorkRequest.endIndex-loopDataThreadWorkRequest.startIndex+1;
        dataThreadProgress.type = "Loop";

        for(int i=loopDataThreadWorkRequest.startIndex;i<loopDataThreadWorkRequest.endIndex;i++){
            int currentIndex = i;
            dataThreadWorkList.add(new BusinessFlow() {
                @Override
                public void executeBusinessFlow(FlowContext flowContext) throws Exception {
                    flowContext.putThreadLocalData("delta", 1)
                            .putThreadLocalData("handleFunction", new FunctionFlow() {
                                @Override
                                public void executeFunction(FlowContext flowContext) throws Exception {
                                    loopDataThreadWorkRequest.loopDataThreadHandler.handleLoop(currentIndex);
                                }
                            });
                }

                @Override
                public String name() {
                    return "单个Loop类型任务";
                }
            });
        }
    }

    @Override
    public String name() {
        return "设置Loop类型任务线程";
    }
}
