package cn.schoolwow.data.thread.module.execute.type.flow.map;

import cn.schoolwow.data.thread.domain.execute.type.map.MapDataThreadWorkRequest;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import org.apache.commons.lang3.Validate;

public class CheckMapDataThreadWorkRequestFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        MapDataThreadWorkRequest mapDataThreadWorkRequest = (MapDataThreadWorkRequest) flowContext.checkData("mapDataThreadWorkRequest");

        Validate.notNull(mapDataThreadWorkRequest, "执行Map类型请求参数不能为空");
        Validate.notEmpty(mapDataThreadWorkRequest.mapDataThreadHandlerList, "Map类型处理器参数列表不能为空");
    }

    @Override
    public String name() {
        return "检查Map类型请求参数";
    }
}
