package cn.schoolwow.data.thread.module.execute.type.flow.map;

import cn.schoolwow.data.thread.domain.execute.parent.DataThreadWorkRequest;
import cn.schoolwow.data.thread.module.parent.domain.QuickDataThreadConfig;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.io.File;
import java.nio.file.Paths;

public class GetMapFileFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDataThreadConfig quickDataThreadConfig = (QuickDataThreadConfig) flowContext.checkData("quickDataThreadConfig");
        DataThreadWorkRequest dataThreadWorkRequest = (DataThreadWorkRequest) flowContext.checkData("dataThreadWorkRequest");
        String id = (String) flowContext.checkData("id");

        File mapFile = Paths.get(quickDataThreadConfig.workDir).resolve(dataThreadWorkRequest.name).resolve("map-"+dataThreadWorkRequest.name+"-"+id+".txt").toFile();
        flowContext.putThreadLocalData("mapFile", mapFile);
    }

    @Override
    public String name() {
        return "判断map文件是否存在";
    }
}
