package cn.schoolwow.data.thread.module.execute.type.flow.map;

import cn.schoolwow.data.thread.domain.execute.type.map.MapDataThreadHandler;
import cn.schoolwow.data.thread.domain.execute.type.map.MapDataThreadWorkRequest;
import cn.schoolwow.data.thread.domain.execute.type.map.MapFileResult;
import cn.schoolwow.data.thread.domain.execute.type.map.MapWorkResult;
import cn.schoolwow.data.thread.domain.progress.DataThreadProgress;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.flow.FunctionFlow;

import java.util.ArrayList;
import java.util.List;

public class SetMapDataThreadWorkFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        MapDataThreadWorkRequest mapDataThreadWorkRequest = (MapDataThreadWorkRequest) flowContext.checkData("mapDataThreadWorkRequest");
        DataThreadProgress dataThreadProgress = (DataThreadProgress) flowContext.checkData("dataThreadProgress");
        List<BusinessFlow> dataThreadWorkList = (List<BusinessFlow>) flowContext.getData("dataThreadWorkList");

        dataThreadProgress.total = mapDataThreadWorkRequest.mapDataThreadHandlerList.size();
        dataThreadProgress.type = "Map";

        final List<String> idList = new ArrayList<>();
        flowContext.putTemporaryData("idList", idList);

        for(MapDataThreadHandler mapDataThreadHandler:mapDataThreadWorkRequest.mapDataThreadHandlerList){
            dataThreadWorkList.add(new BusinessFlow() {
                @Override
                public void executeBusinessFlow(FlowContext flowContext) throws Exception {
                    flowContext.putThreadLocalData("delta", 1)
                            .putThreadLocalData("handleFunction", new FunctionFlow() {
                                @Override
                                public void executeFunction(FlowContext flowContext) throws Exception {
                                    MapFileResult mapFileResult = mapDataThreadHandler.map();
                                    if(null==mapFileResult){
                                        return;
                                    }
                                    synchronized (idList){
                                        idList.add(mapFileResult.id);
                                    }
                                    flowContext.startFlow(new GetMapFileFlow())
                                            .next(new WriteMapFileFlow())
                                            .putThreadLocalData("id", mapFileResult.id)
                                            .putThreadLocalData("mapFileResult", mapFileResult)
                                            .execute();
                                }
                            });
                }

                @Override
                public String name() {
                    return "单个Map类型任务";
                }
            });
        }
        MapWorkResult mapWorkResult = new MapWorkResult();
        mapWorkResult.name = mapDataThreadWorkRequest.name;
        mapWorkResult.idList = (List<String>) flowContext.getData("idList");
        flowContext.putTemporaryData("mapWorkResult", mapWorkResult);
    }

    @Override
    public String name() {
        return "设置Map类型任务线程";
    }

}
