package cn.schoolwow.data.thread.module.execute.type.flow.map;

import cn.schoolwow.data.thread.domain.execute.type.map.MapFileResult;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import org.apache.commons.io.FileUtils;

import java.io.File;

public class WriteMapFileFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        File mapFile = (File) flowContext.checkData("mapFile");
        MapFileResult mapFileResult = (MapFileResult) flowContext.checkData("mapFileResult");

        FileUtils.writeStringToFile(mapFile, mapFileResult.content, "UTF-8");
    }

    @Override
    public String name() {
        return "写入map文件";
    }
}
