package cn.schoolwow.data.thread.module.execute.type.flow.reduce;

import cn.schoolwow.data.thread.domain.execute.type.reduce.ReduceDataThreadWorkRequest;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import org.apache.commons.lang3.Validate;

public class CheckReduceDataThreadWorkRequestFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        ReduceDataThreadWorkRequest reduceDataThreadWorkRequest = (ReduceDataThreadWorkRequest) flowContext.checkData("reduceDataThreadWorkRequest");

        Validate.notNull(reduceDataThreadWorkRequest, "执行Reduce类型请求参数不能为空");
        Validate.notNull(reduceDataThreadWorkRequest.mapWorkResult, "分散任务结果不能为空");
        Validate.notNull(reduceDataThreadWorkRequest.reduceDataThreadHandler, "合并函数不能为空");
    }

    @Override
    public String name() {
        return "检查Reduce类型请求参数";
    }
}
