package cn.schoolwow.data.thread.module.execute.type.flow.reduce;

import cn.schoolwow.data.thread.domain.execute.type.map.MapFileResult;
import cn.schoolwow.data.thread.domain.execute.type.reduce.ReduceDataThreadWorkRequest;
import cn.schoolwow.data.thread.domain.progress.DataThreadProgress;
import cn.schoolwow.data.thread.module.execute.type.flow.map.GetMapFileFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowDataFeature;
import cn.schoolwow.quickflow.dto.FlowContextDataRange;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.flow.FunctionFlow;
import org.apache.commons.io.FileUtils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class SetReduceWorkFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        ReduceDataThreadWorkRequest reduceDataThreadWorkRequest = (ReduceDataThreadWorkRequest) flowContext.checkData("reduceDataThreadWorkRequest");
        DataThreadProgress dataThreadProgress = (DataThreadProgress) flowContext.checkData("dataThreadProgress");
        List<BusinessFlow> dataThreadWorkList = (List<BusinessFlow>) flowContext.getData("dataThreadWorkList");

        dataThreadProgress.total = reduceDataThreadWorkRequest.mapWorkResult.idList.size();
        dataThreadProgress.type = "Reduce";
        dataThreadProgress.description = "id列表:"+reduceDataThreadWorkRequest.mapWorkResult.idList;

        final List<String> idList = new ArrayList<>();
        flowContext.putTemporaryData("idList", idList);

        for(String id:reduceDataThreadWorkRequest.mapWorkResult.idList){
            dataThreadWorkList.add(new BusinessFlow() {
                @Override
                public void executeBusinessFlow(FlowContext flowContext) throws Exception {
                    flowContext.putThreadLocalData("delta", 1)
                            .putThreadLocalData("handleFunction", new FunctionFlow() {
                                @Override
                                public void executeFunction(FlowContext flowContext) throws Exception {
                                    File file = (File) flowContext.startFlow(new GetMapFileFlow())
                                            .putThreadLocalData("id", id)
                                            .execute()
                                            .checkData("mapFile");
                                    String content = FileUtils.readFileToString(file, "UTF-8");
                                    MapFileResult mapFile = new MapFileResult();
                                    mapFile.id = id;
                                    mapFile.content = content;
                                    reduceDataThreadWorkRequest.reduceDataThreadHandler.reduce(mapFile, file);
                                    if(reduceDataThreadWorkRequest.deleteFile){
                                        FileUtils.forceDelete(file);
                                        flowContext.putFlowContextData("mapDirectory", file.getParent(), FlowContextDataRange.Flow,
                                                FlowDataFeature.TemporaryData, FlowDataFeature.SkipExistData);
                                    }
                                }
                            });
                }

                @Override
                public String name() {
                    return "单个Reduce类型任务";
                }
            });
        }
    }

    @Override
    public String name() {
        return "设置Reduce类型任务线程";
    }

}
