package cn.schoolwow.data.thread.module.execute.type.flow.single;

import cn.schoolwow.data.thread.domain.execute.type.single.SingleDataThreadWorkRequest;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import org.apache.commons.lang3.Validate;

public class CheckSingleDataThreadWorkRequestFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        SingleDataThreadWorkRequest singleDataThreadWorkRequest = (SingleDataThreadWorkRequest) flowContext.checkData("singleDataThreadWorkRequest");

        Validate.notNull(singleDataThreadWorkRequest, "执行Single类型请求参数不能为空");
        Validate.notNull(singleDataThreadWorkRequest.list, "待处理列表不能为空");
        Validate.notEmpty(singleDataThreadWorkRequest.list, "待处理列表不能为空");
        Validate.notNull(singleDataThreadWorkRequest.singleDataThreadHandler, "Loop类型处理器参数不能为空");
    }

    @Override
    public String name() {
        return "检查Single类型请求参数";
    }
}
