package cn.schoolwow.data.thread.module.execute.type.flow.single;

import cn.schoolwow.data.thread.domain.execute.type.single.SingleDataThreadWorkRequest;
import cn.schoolwow.data.thread.domain.progress.DataThreadProgress;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.flow.FunctionFlow;

import java.util.List;

public class SetSingleWorkFlow<T> implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        SingleDataThreadWorkRequest<T> singleDataThreadWorkRequest = (SingleDataThreadWorkRequest<T>) flowContext.checkData("singleDataThreadWorkRequest");
        DataThreadProgress dataThreadProgress = (DataThreadProgress) flowContext.checkData("dataThreadProgress");
        List<BusinessFlow> dataThreadWorkList = (List<BusinessFlow>) flowContext.getData("dataThreadWorkList");

        dataThreadProgress.total = singleDataThreadWorkRequest.list.size();
        dataThreadProgress.type = "Single";

        for(int i=0;i<singleDataThreadWorkRequest.list.size();i++){
            int index = i;
            dataThreadWorkList.add(new BusinessFlow() {
                @Override
                public void executeBusinessFlow(FlowContext flowContext) throws Exception {
                    flowContext.putThreadLocalData("delta", 1)
                            .putThreadLocalData("handleFunction", new FunctionFlow() {
                                @Override
                                public void executeFunction(FlowContext flowContext) throws Exception {
                                    singleDataThreadWorkRequest.singleDataThreadHandler.handleSingleList(singleDataThreadWorkRequest.list.get(index));
                                }
                            });
                }

                @Override
                public String name() {
                    return "单个Single类型任务";
                }
            });
        }
    }

    @Override
    public String name() {
        return "设置Single类型任务线程";
    }
}
