package cn.schoolwow.data.thread.module.execute.type.service;

import cn.schoolwow.data.thread.module.execute.common.after.flow.AfterExecuteFlow;
import cn.schoolwow.data.thread.module.execute.common.before.service.BeforeExecuteCompositeBusiness;
import cn.schoolwow.data.thread.module.execute.type.flow.single.CheckSingleDataThreadWorkRequestFlow;
import cn.schoolwow.data.thread.module.execute.type.flow.single.SetSingleWorkFlow;
import cn.schoolwow.quickflow.QuickFlowExecutor;
import cn.schoolwow.quickflow.flow.CompositeBusinessFlow;

public class ExecuteSingleDataThreadWorkCompositeBusiness<T> implements CompositeBusinessFlow {
    @Override
    public void executeCompositeBusiness(QuickFlowExecutor quickFlowExecutor) {
        quickFlowExecutor.next(new BeforeExecuteCompositeBusiness())
                .next(new CheckSingleDataThreadWorkRequestFlow())
                .next(new SetSingleWorkFlow<T>())
                .next(new AfterExecuteFlow());
    }

    @Override
    public String name() {
        return "执行Single类型任务复合流程";
    }
}
