package cn.schoolwow.data.thread.module.parent.domain;

import cn.schoolwow.data.thread.domain.progress.ProgressListener;
import cn.schoolwow.data.thread.module.producerConsumer.domain.ConsumerContext;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class QuickDataThreadConfig {
    /**工作文件夹*/
    public String workDir = System.getProperty("java.io.tmpdir") + File.separator + "QuickDataThread";

    /**进度监听*/
    public ProgressListener progressListener;

    /**指定线程个数*/
    public int threadCount = Runtime.getRuntime().availableProcessors();

    /**超时时间*/
    public int timeout = 1;

    /**超时时间单位*/
    public TimeUnit timeoutUnit = TimeUnit.HOURS;

    /**是否等待线程执行完毕*/
    public boolean waitFor = true;

    /**是否记录到进度列表*/
    public boolean recordProgress = true;

    /**消费者*/
    public Map<String, ConsumerContext> consumerContextMap = new HashMap<>();

}
