package cn.schoolwow.data.thread.module.parent.domain;

import cn.schoolwow.data.thread.module.execute.kit.DataThreadExecuteImpl;
import cn.schoolwow.data.thread.module.producerConsumer.kit.DataThreadProducerConsumerImpl;
import cn.schoolwow.data.thread.module.progress.kit.DataThreadProgressOperationImpl;
import cn.schoolwow.quickflow.QuickFlow;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class QuickDataThreadInvocationHandler implements InvocationHandler {
    private Object[] interfaceInstanceArray;

    public QuickDataThreadInvocationHandler(QuickFlow quickFlow) {
        interfaceInstanceArray = new Object[]{
                new DataThreadExecuteImpl(quickFlow),
                new DataThreadProgressOperationImpl(quickFlow),
                new DataThreadProducerConsumerImpl(quickFlow)
        };
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String interfaceName = method.getDeclaringClass().getSimpleName();
        for(Object interfaceInstance:interfaceInstanceArray){
            Class interfaceClass = interfaceInstance.getClass().getInterfaces()[0];
            if(interfaceClass.getSimpleName().equalsIgnoreCase(interfaceName)){
                try {
                    return method.invoke(interfaceInstance, args);
                }catch (InvocationTargetException e){
                    Throwable targetException = e.getTargetException();
                    throw targetException;
                }
            }
        }
        return method.invoke(this, args);
    }
}
