package cn.schoolwow.data.thread.module.producerConsumer.domain;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public class RegisterConsumerRequest<T> {
    /**
     * 间隔时间(毫秒)消费
     * */
    public int intervalTime = 3000;

    /**
     * 获取消息个数大于指定个数时消费
     * */
    public int messageSize = 10;

    /**
     * 消费类型
     * */
    public Class messageType;

    /**
     * 同步队列
     * */
    public BlockingQueue<T> blockingQueue = new ArrayBlockingQueue<T>(1024);

    /**
     * 指定消息处理逻辑
     * */
    public MessageConsumer<T> messageConsumer;
}
