package cn.schoolwow.data.thread.module.producerConsumer.flow;

import cn.schoolwow.data.thread.module.parent.domain.QuickDataThreadConfig;
import cn.schoolwow.data.thread.module.producerConsumer.domain.ConsumerContext;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class InitialConsumerThreadFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDataThreadConfig quickDataThreadConfig = (QuickDataThreadConfig) flowContext.checkData("quickDataThreadConfig");

        for(ConsumerContext consumerContext:quickDataThreadConfig.consumerContextMap.values()){
            consumerContext.threadPoolExecutor.execute(()->{
                List list = new ArrayList<>();
                long startTime = System.currentTimeMillis();
                while(true){
                    try {
                        Object message = consumerContext.registerConsumerRequest.blockingQueue.poll(1, TimeUnit.SECONDS);
                        if(null!=message){
                            list.add(message);
                        }

                        long endTime = System.currentTimeMillis();
                        long durationTime = endTime-startTime;
                        if(!list.isEmpty()&&durationTime>=consumerContext.registerConsumerRequest.intervalTime){
                            consumerContext.registerConsumerRequest.messageConsumer.consumeMessage(list);
                            list.clear();
                            startTime = System.currentTimeMillis();
                        }
                        if(!list.isEmpty()&&list.size()>=consumerContext.registerConsumerRequest.messageSize){
                            consumerContext.registerConsumerRequest.messageConsumer.consumeMessage(list);
                            list.clear();
                            startTime = System.currentTimeMillis();
                        }
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    @Override
    public String name() {
        return "初始化消费者线程";
    }

}
