package cn.schoolwow.data.thread.module.producerConsumer.flow;

import cn.schoolwow.data.thread.module.parent.domain.QuickDataThreadConfig;
import cn.schoolwow.data.thread.module.producerConsumer.domain.ConsumerContext;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class ProduceMessageFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDataThreadConfig quickDataThreadConfig = (QuickDataThreadConfig) flowContext.checkData("quickDataThreadConfig");
        Object message = flowContext.checkData("message");

        String className = message.getClass().getName();
        ConsumerContext consumerContext = quickDataThreadConfig.consumerContextMap.get(className);
        if(!quickDataThreadConfig.consumerContextMap.containsKey(className)){
            throw new IllegalArgumentException("未注册的消费者类型!类型:"+className);
        }
        consumerContext.registerConsumerRequest.blockingQueue.add(message);
    }

    @Override
    public String name() {
        return "生产消息";
    }
}
