package cn.schoolwow.data.thread.module.producerConsumer.flow;

import cn.schoolwow.data.thread.module.parent.domain.QuickDataThreadConfig;
import cn.schoolwow.data.thread.module.producerConsumer.domain.ConsumerContext;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.util.List;

public class ProduceMessageListFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDataThreadConfig quickDataThreadConfig = (QuickDataThreadConfig) flowContext.checkData("quickDataThreadConfig");
        List messageList = (List) flowContext.checkData("messageList");

        String className = messageList.get(0).getClass().getName();
        ConsumerContext consumerContext = quickDataThreadConfig.consumerContextMap.get(className);
        if(!quickDataThreadConfig.consumerContextMap.containsKey(className)){
            throw new IllegalArgumentException("未注册的消费者类型!类型:"+className);
        }
        for(Object message:messageList){
            consumerContext.registerConsumerRequest.blockingQueue.add(message);
        }
    }

    @Override
    public String name() {
        return "生产消息";
    }
}
