package cn.schoolwow.data.thread.module.producerConsumer.kit;

import cn.schoolwow.data.thread.module.producerConsumer.flow.ProduceMessageFlow;
import cn.schoolwow.data.thread.module.producerConsumer.flow.ProduceMessageListFlow;
import cn.schoolwow.quickflow.QuickFlow;

import java.util.List;

public class DataThreadProducerConsumerImpl implements DataThreadProducerConsumer{
    private QuickFlow quickFlow;

    public DataThreadProducerConsumerImpl(QuickFlow quickFlow) {
        this.quickFlow = quickFlow;
    }

    @Override
    public void produceMessage(Object message) {
        quickFlow.startFlow(new ProduceMessageFlow())
                .putCurrentCompositeFlowData("message", message)
                .execute();
    }

    @Override
    public void produceMessageList(List messageList) {
        quickFlow.startFlow(new ProduceMessageListFlow())
                .putCurrentCompositeFlowData("messageList", messageList)
                .execute();
    }
}
