package cn.schoolwow.data.thread.module.progress.kit;

import cn.schoolwow.data.thread.domain.progress.DataThreadProgress;
import cn.schoolwow.quickflow.QuickFlow;

import java.util.Iterator;
import java.util.List;

public class DataThreadProgressOperationImpl implements DataThreadProgressOperation {
    private QuickFlow quickFlow;

    public DataThreadProgressOperationImpl(QuickFlow quickFlow) {
        this.quickFlow = quickFlow;
    }

    /**获取进度列表*/
    public List<DataThreadProgress> getDataThreadProgressList(){
        List<DataThreadProgress> dataThreadProgressList = (List<DataThreadProgress>) quickFlow.getContextData("dataThreadProgressList");
        return dataThreadProgressList;
    }

    /**中断任务*/
    public void interruptDataThread(long id){
        List<DataThreadProgress> dataThreadProgressList = getDataThreadProgressList();
        for(DataThreadProgress dataThreadProgress:dataThreadProgressList){
            if(dataThreadProgress.id==id){
                dataThreadProgress.status = "中断结束";
                dataThreadProgress.threadPoolExecutor.shutdownNow();
            }
        }
    }

    /**删除进度信息*/
    public void deleteDataThreadProgress(long id){
        List<DataThreadProgress> dataThreadProgressList = getDataThreadProgressList();
        Iterator<DataThreadProgress> iterator = dataThreadProgressList.iterator();
        while(iterator.hasNext()){
            DataThreadProgress dataThreadProgress = iterator.next();
            if(dataThreadProgress.id==id){
                //判断是否已经结束或者抛出异常
                if(null!=dataThreadProgress.endTime||null!=dataThreadProgress.exception){
                    iterator.remove();
                }else{
                    throw new IllegalArgumentException("只允许删除任务正常结束或者异常结束的数据线程!进度id:"+id);
                }
            }
        }
    }
}
