/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.data.thread;

import cn.schoolwow.data.thread.QuickDataThread;
import cn.schoolwow.data.thread.domain.progress.ProgressListener;
import cn.schoolwow.data.thread.module.parent.domain.QuickDataThreadConfig;
import cn.schoolwow.data.thread.module.parent.domain.QuickDataThreadInvocationHandler;
import cn.schoolwow.data.thread.module.producerConsumer.domain.ConsumerContext;
import cn.schoolwow.data.thread.module.producerConsumer.domain.RegisterConsumerRequest;
import cn.schoolwow.data.thread.module.producerConsumer.flow.InitialConsumerThreadFlow;
import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.QuickFlowBuilder;
import cn.schoolwow.quickflow.domain.FlowDataFeature;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;

public class QuickDataThreadBuilder {
    private QuickDataThreadConfig quickDataThreadConfig = new QuickDataThreadConfig();

    public static QuickDataThreadBuilder newInstance() {
        return new QuickDataThreadBuilder();
    }

    public QuickDataThreadBuilder workDir(String workDir) throws IOException {
        Files.createDirectories(Paths.get(workDir, new String[0]), new FileAttribute[0]);
        this.quickDataThreadConfig.workDir = workDir;
        return this;
    }

    public QuickDataThreadBuilder progressListener(ProgressListener progressListener) {
        this.quickDataThreadConfig.progressListener = progressListener;
        return this;
    }

    public QuickDataThreadBuilder threadCount(int threadCount) {
        this.quickDataThreadConfig.threadCount = threadCount;
        return this;
    }

    public QuickDataThreadBuilder timeout(Integer timeout, TimeUnit timeoutUnit) {
        this.quickDataThreadConfig.timeout = timeout;
        this.quickDataThreadConfig.timeoutUnit = timeoutUnit;
        return this;
    }

    public QuickDataThreadBuilder waitFor(boolean waitFor) {
        this.quickDataThreadConfig.waitFor = waitFor;
        return this;
    }

    public QuickDataThreadBuilder recordProgress(boolean recordProgress) {
        this.quickDataThreadConfig.recordProgress = recordProgress;
        return this;
    }

    public <T> QuickDataThreadBuilder registerConsumer(RegisterConsumerRequest<T> registerConsumerRequest) {
        Validate.notNull((Object)registerConsumerRequest.messageType, (String)"\u672a\u8bbe\u7f6e\u6d88\u606f\u7c7b\u578b", (Object[])new Object[0]);
        Validate.notNull(registerConsumerRequest.messageConsumer, (String)"\u672a\u8bbe\u7f6e\u6d88\u606f\u5904\u7406\u5668", (Object[])new Object[0]);
        ConsumerContext consumerContext = new ConsumerContext();
        consumerContext.registerConsumerRequest = registerConsumerRequest;
        consumerContext.messageTypeClassName = registerConsumerRequest.messageType.getName();
        this.quickDataThreadConfig.consumerContextMap.put(consumerContext.messageTypeClassName, consumerContext);
        return this;
    }

    public QuickDataThread build() {
        QuickFlow quickFlow = QuickFlowBuilder.newInstance().putContextData("dataThreadProgressList", new ArrayList(), new FlowDataFeature[0]).putContextData("quickDataThreadConfig", (Object)this.quickDataThreadConfig, new FlowDataFeature[0]);
        quickFlow.executeFlow(new BusinessFlow[]{new InitialConsumerThreadFlow()});
        QuickDataThreadInvocationHandler quickDataThreadInvocationHandler = new QuickDataThreadInvocationHandler(quickFlow);
        QuickDataThread quickDataThread = (QuickDataThread)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{QuickDataThread.class}, (InvocationHandler)quickDataThreadInvocationHandler);
        return quickDataThread;
    }
}

