/*
 * Decompiled with CFR 0.152.
 */
package cn.wandersnail.common;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateUtils {
    public static boolean isSame(int field, long date1, long date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTimeInMillis(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTimeInMillis(date2);
        return DateUtils.isSame(field, cal1, cal2);
    }

    public static boolean isSame(int field, Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return false;
        }
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        return DateUtils.isSame(field, cal1, cal2);
    }

    public static boolean isSame(int field, Calendar date1, Calendar date2) {
        if (date1 == null || date2 == null) {
            return false;
        }
        switch (field) {
            case 5: {
                return date1.get(0) == date2.get(0) && date1.get(1) == date2.get(1) && date1.get(6) == date2.get(6);
            }
            case 2: {
                return date1.get(0) == date2.get(0) && date1.get(1) == date2.get(1) && date1.get(2) == date2.get(2);
            }
            case 1: {
                return date1.get(0) == date2.get(0) && date1.get(1) == date2.get(1);
            }
        }
        return false;
    }

    public static Date getDay(Date date, int offset) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, offset);
        return calendar.getTime();
    }

    public static long getDay(long date, int offset) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(date);
        calendar.add(5, offset);
        return calendar.getTimeInMillis();
    }

    public static Date getMonth(Date date, int offset) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, offset);
        return calendar.getTime();
    }

    public static long getMonth(long date, int offset) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(date);
        calendar.add(2, offset);
        return calendar.getTimeInMillis();
    }

    public static Date getYear(Date date, int offset) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, offset);
        return calendar.getTime();
    }

    public static long getYear(long date, int offset) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(date);
        calendar.add(1, offset);
        return calendar.getTimeInMillis();
    }

    public static Date getPreviousDay(Date date) {
        return DateUtils.getDay(date, -1);
    }

    public static long getPreviousDay(long date) {
        return DateUtils.getDay(date, -1);
    }

    public static Date getNextDay(Date date) {
        return DateUtils.getDay(date, 1);
    }

    public static long getNextDay(long date) {
        return DateUtils.getDay(date, 1);
    }

    public static String formatDate(Date date, String pattern, Locale locale) {
        return new SimpleDateFormat(pattern, locale).format(date);
    }

    public static String formatDate(long time, String pattern, Locale locale) {
        return new SimpleDateFormat(pattern, locale).format(time);
    }

    public static String formatDate(Date date, String pattern) {
        return new SimpleDateFormat(pattern, Locale.getDefault()).format(date);
    }

    public static String formatDate(long time, String pattern) {
        return new SimpleDateFormat(pattern, Locale.getDefault()).format(time);
    }

    public static int getDayOfWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(7);
    }

    public static long getMillisInDay(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(11) * 3600000 + c.get(12) * 60000 + c.get(13) * 1000 + c.get(14);
    }

    public static Date parseStringDate(String date, String pattern, Locale locale) {
        try {
            return new SimpleDateFormat(pattern, locale).parse(date);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("\u65e5\u671f\u683c\u5f0f\u4e0d\u5bf9");
        }
    }

    public static Date parseStringDate(String date, String pattern) {
        try {
            return new SimpleDateFormat(pattern, Locale.getDefault()).parse(date);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("\u65e5\u671f\u683c\u5f0f\u4e0d\u5bf9");
        }
    }

    public static int daysBetween(Date dateA, Date dateB) {
        Calendar a = DateUtils.getStartOfDay(dateA);
        Calendar b = DateUtils.getStartOfDay(dateB);
        return (int)((b.getTimeInMillis() - a.getTimeInMillis()) / 86400000L);
    }

    public static int daysBetween(long dateA, long dateB) {
        dateA = DateUtils.getStartOfDay(dateA);
        dateB = DateUtils.getStartOfDay(dateB);
        return (int)((dateB - dateA) / 86400000L);
    }

    public static Calendar getStartOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    public static long getStartOfDay(long date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(date));
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    public static int getActualMaximum(Date date, int field) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.getActualMaximum(field);
    }

    public static int getDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static int getMonthOfYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(2);
    }

    public static Date getStartOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static Date getEndOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    public static Date getEndOfYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, 11);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    public static Date getStartOfYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, 0);
        calendar.set(5, 1);
        return calendar.getTime();
    }
}

