/*
 * Decompiled with CFR 0.152.
 */
package cn.wandersnail.common;

import cn.wandersnail.common.IOUtils;
import cn.wandersnail.common.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class EncryptUtils {
    public static final String MD5 = "MD5";
    public static final String SHA1 = "SHA1";

    public static String addSeparator(String code, String separator) {
        try {
            StringBuilder sb = new StringBuilder();
            int loopTimes = code.length();
            for (int i = 0; i < loopTimes; i += 2) {
                if (i != loopTimes - 2) {
                    sb.append(code.substring(i, i + 2)).append(separator == null ? "" : separator);
                    continue;
                }
                sb.append(code.substring(i, i + 2));
            }
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getMD5Code(String plainText, int iterations) {
        if (iterations > 0) {
            String result = EncryptUtils.getMD5Code(plainText);
            if (--iterations > 0 && result != null) {
                result = EncryptUtils.getMD5Code(result, iterations);
            }
            return result;
        }
        return null;
    }

    public static String getSHA1Code(String plainText, int iterations) {
        if (iterations > 0) {
            String result = EncryptUtils.getSHA1Code(plainText);
            if (--iterations > 0 && result != null) {
                result = EncryptUtils.getSHA1Code(result, iterations);
            }
            return result;
        }
        return null;
    }

    public static String replaceMessageDigestCharacter(String code, int offset, int len) {
        char[] charArr = "1234567890abcdef".toCharArray();
        char[] md5Arr = code.toCharArray();
        Random random = new Random();
        for (int i = offset; i < offset + len; ++i) {
            char randomChar;
            md5Arr[i] = randomChar = charArr[random.nextInt(charArr.length)];
        }
        return new String(md5Arr, 0, md5Arr.length);
    }

    public static String getMD5Code(String plainText) {
        return EncryptUtils.encryptByMessageDigest(plainText.getBytes(), MD5);
    }

    public static String getSHA1Code(String plainText) {
        return EncryptUtils.encryptByMessageDigest(plainText.getBytes(), SHA1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileMD5Code(String path) {
        String string;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(path);
            String code = EncryptUtils.getMD5Code(fis);
            ((InputStream)fis).close();
            string = code;
        }
        catch (Exception e) {
            String string2;
            try {
                e.printStackTrace();
                string2 = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
            IOUtils.closeQuietly(fis);
            return string2;
        }
        IOUtils.closeQuietly(fis);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileSHA1Code(String path) {
        String string;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(path);
            String code = EncryptUtils.getSHA1Code(fis);
            ((InputStream)fis).close();
            string = code;
        }
        catch (Exception e) {
            String string2;
            try {
                e.printStackTrace();
                string2 = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
            IOUtils.closeQuietly(fis);
            return string2;
        }
        IOUtils.closeQuietly(fis);
        return string;
    }

    public static String getFileMD5Code(File file) {
        return file == null ? null : EncryptUtils.getFileMD5Code(file.getPath());
    }

    public static String getFileSHA1Code(File file) {
        return file == null ? null : EncryptUtils.getFileSHA1Code(file.getPath());
    }

    public static String getMD5Code(InputStream inputStream) {
        return EncryptUtils.encryptByMessageDigest(inputStream, MD5);
    }

    public static String getSHA1Code(InputStream inputStream) {
        return EncryptUtils.encryptByMessageDigest(inputStream, SHA1);
    }

    public static String encryptByMessageDigest(InputStream inputStream, String algorithm) {
        try {
            int len;
            MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
            byte[] buf = new byte[40960];
            while ((len = inputStream.read(buf)) != -1) {
                messageDigest.update(buf, 0, len);
            }
            return EncryptUtils.encryptByMessageDigest(messageDigest);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encryptByMessageDigest(byte[] bytes, String algorithm) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.update(bytes);
            return EncryptUtils.encryptByMessageDigest(md);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String encryptByMessageDigest(MessageDigest md) {
        byte[] digest = md.digest();
        StringBuilder toRet = new StringBuilder();
        for (byte b : digest) {
            String hex = StringUtils.toHex(b & 0xFF);
            toRet.append(hex);
        }
        return toRet.toString();
    }

    public static String encrypt(String seed, String plain, String iv) throws Exception {
        SecretKeySpec keySpec = new SecretKeySpec(seed.getBytes(), "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(1, (Key)keySpec, new IvParameterSpec(iv.getBytes()));
        return Base64.getEncoder().encodeToString(cipher.doFinal(plain.getBytes()));
    }

    public static String decrypt(String seed, String encrypted, String iv) throws Exception {
        SecretKeySpec keySpec = new SecretKeySpec(seed.getBytes(), "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(2, (Key)keySpec, new IvParameterSpec(iv.getBytes()));
        byte[] enc = Base64.getDecoder().decode(encrypted.getBytes());
        return new String(cipher.doFinal(enc));
    }
}

