/*
 * Decompiled with CFR 0.152.
 */
package cn.wandersnail.common;

import cn.wandersnail.common.IOUtils;
import cn.wandersnail.common.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.Objects;
import java.util.zip.GZIPOutputStream;

public class FileUtils {
    public static String formatFileSize(long size, DecimalFormat format) {
        if (format == null) {
            format = new DecimalFormat("#.00");
        }
        if (size < 1024L) {
            return size + " B";
        }
        if (size < 0x100000L) {
            return format.format((double)size / 1024.0) + " KB";
        }
        if (size < 0x40000000L) {
            return format.format((double)size / 1048576.0) + " MB";
        }
        if (size < 0x10000000000L) {
            return format.format((double)size / 1.073741824E9) + " GB";
        }
        if (size < 0x4000000000000L) {
            return format.format((double)size / 1.099511627776E12) + " TB";
        }
        if (size < 0x1000000000000000L) {
            return format.format((double)size / 1.125899906842624E15) + " PB";
        }
        return "size: out of range";
    }

    public static String formatFileSize(long size) {
        return FileUtils.formatFileSize(size, null);
    }

    public static String deleteSuffix(String fileName) {
        if (fileName.contains(".")) {
            fileName = fileName.substring(0, fileName.lastIndexOf("."));
        }
        return fileName;
    }

    public static String getSuffix(String s) {
        if (s != null && s.contains(".")) {
            return s.substring(s.lastIndexOf("."));
        }
        return null;
    }

    public static String getFileName(String path) {
        return FileUtils.getFileName(path, false);
    }

    public static String getFileName(String path, boolean withoutSuffix) {
        if (path.contains("/") || path.contains("\\")) {
            int beginIndex = path.lastIndexOf("\\");
            String fileName = path;
            if (beginIndex != -1) {
                fileName = fileName.substring(beginIndex + 1);
            }
            if ((beginIndex = fileName.lastIndexOf("/")) != -1) {
                fileName = fileName.substring(beginIndex + 1);
            }
            return withoutSuffix ? FileUtils.deleteSuffix(fileName) : fileName;
        }
        return withoutSuffix ? FileUtils.deleteSuffix(path) : path;
    }

    public static File checkAndRename(File target) {
        Objects.requireNonNull(target, "target is null");
        if (target.exists()) {
            String fileName = target.getName();
            if (fileName.contains(".")) {
                String sub = fileName.substring(0, fileName.lastIndexOf("."));
                fileName = fileName.replace(sub, StringUtils.randomUuid() + "_" + sub);
            } else {
                fileName = StringUtils.randomUuid() + "_" + fileName;
            }
            return new File(target.getParent(), fileName);
        }
        return target;
    }

    public static String[] removeDuplicate(String dup, String ... strs) {
        String[] out = new String[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            out[i] = strs[i].replace(dup + "+", "");
        }
        return out;
    }

    public static String generateRandonFileName(String fileName) {
        return StringUtils.randomUuid() + FileUtils.getSuffix(fileName);
    }

    public static byte[] compressByGZIP(byte[] bytes) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            GZIPOutputStream out = new GZIPOutputStream(baos);
            out.write(bytes);
            out.finish();
            out.flush();
            out.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            return bytes;
        }
    }

    public static void compressByGZIP(File src, File target) {
        FileUtils.compressByGZIP(src, target, 40960);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compressByGZIP(File src, File target, int bufferSize) {
        if (!src.exists()) {
            return;
        }
        FileInputStream fis = null;
        GZIPOutputStream out = null;
        try {
            int len;
            fis = new FileInputStream(src);
            out = new GZIPOutputStream(new FileOutputStream(target));
            byte[] buffer = new byte[bufferSize];
            while ((len = fis.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
            out.finish();
            out.flush();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis, out);
                throw throwable;
            }
            IOUtils.closeQuietly(fis, out);
        }
        IOUtils.closeQuietly(fis, out);
    }

    public static void toFile(InputStream inputStream, File target) {
        FileUtils.toFile(inputStream, target, 40960);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toFile(InputStream inputStream, File target, int bufferSize) {
        BufferedOutputStream out = null;
        try {
            int len;
            out = new BufferedOutputStream(new FileOutputStream(target));
            BufferedInputStream in = new BufferedInputStream(inputStream);
            byte[] buffer = new byte[bufferSize];
            while ((len = in.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, len);
            }
            ((OutputStream)out).flush();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly(out);
        }
        IOUtils.closeQuietly(out);
    }

    public static void copyFile(File src, File target) {
        FileUtils.copyFile(src, target, 40960);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File target, int bufferSize) {
        if (!src.exists()) {
            return;
        }
        BufferedInputStream fis = null;
        BufferedOutputStream fos = null;
        try {
            int len;
            fis = new BufferedInputStream(new FileInputStream(src));
            fos = new BufferedOutputStream(new FileOutputStream(target));
            byte[] buffer = new byte[bufferSize];
            while ((len = fis.read(buffer)) != -1) {
                fos.write(buffer, 0, len);
            }
            fos.flush();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis, fos);
                throw throwable;
            }
            IOUtils.closeQuietly(fis, fos);
        }
        IOUtils.closeQuietly(fis, fos);
    }

    public static void copyDir(File srcDir, File targetDir) {
        FileUtils.copyDir(srcDir, targetDir, 40960);
    }

    public static void copyDir(File srcDir, File targetDir, int bufferSize) {
        File[] files;
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        if ((files = srcDir.listFiles()) != null && files.length > 0) {
            for (File file : files) {
                if (file.isFile()) {
                    FileUtils.copyFile(file, new File(targetDir, file.getName()), bufferSize);
                    continue;
                }
                FileUtils.copyDir(file, new File(targetDir, file.getName()), bufferSize);
            }
        }
    }

    public static void copy(File src, File target) {
        FileUtils.copy(src, target, 40960);
    }

    public static void copy(File src, File target, int bufferSize) {
        if (src.exists()) {
            if (src.isFile()) {
                FileUtils.copyFile(src, target, bufferSize);
            } else {
                FileUtils.copyDir(src, target, bufferSize);
            }
        }
    }

    public static long getSize(File file) {
        if (file.exists()) {
            if (file.isFile()) {
                return file.length();
            }
            long size = 0L;
            File[] files = file.listFiles();
            if (files != null && files.length > 0) {
                for (File f : files) {
                    if (f.isFile()) {
                        size += f.length();
                        continue;
                    }
                    size += FileUtils.getSize(f);
                }
            }
            return size;
        }
        return 0L;
    }

    public static void deleteDir(File dir) {
        FileUtils.emptyDir(dir);
        dir.delete();
    }

    public static void emptyDir(File dir) {
        File[] files = dir.listFiles();
        if (files != null && files.length > 0) {
            for (File file : files) {
                if (file.isFile()) {
                    file.delete();
                    continue;
                }
                FileUtils.deleteDir(file);
            }
        }
    }

    private static boolean compareAndDeleteSrc(File src, File target) {
        if (src.exists()) {
            if (src.isFile()) {
                if (target.exists() && target.length() == src.length()) {
                    return src.delete();
                }
            } else if (FileUtils.getSize(src) == FileUtils.getSize(target)) {
                FileUtils.deleteDir(src);
                return true;
            }
        }
        return false;
    }

    public static boolean move(File src, File target) {
        return FileUtils.move(src, target, 40960, true);
    }

    public static boolean move(File src, File target, int bufferSize) {
        return FileUtils.move(src, target, bufferSize, true);
    }

    public static boolean move(File src, File target, boolean replace) {
        return FileUtils.move(src, target, 40960, replace);
    }

    public static boolean move(File src, File target, int bufferSize, boolean replace) {
        if (!src.exists()) {
            return false;
        }
        if (!replace) {
            target = FileUtils.checkAndRename(target);
        }
        if (src.isFile()) {
            FileUtils.copyFile(src, target, bufferSize);
        } else {
            FileUtils.copyDir(src, target, bufferSize);
        }
        return FileUtils.compareAndDeleteSrc(src, target);
    }
}

