/*
 * Decompiled with CFR 0.152.
 */
package cn.wandersnail.common;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IOUtils {
    public static void close(Closeable ... closeables) throws IOException {
        if (closeables != null) {
            for (Closeable closeable : closeables) {
                if (closeable == null) continue;
                closeable.close();
            }
        }
    }

    public static void closeQuietly(Closeable ... closeables) {
        try {
            IOUtils.close(closeables);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String getString(InputStream in) throws IOException {
        return IOUtils.getString(in, null);
    }

    public static String getString(InputStream in, String enc) throws IOException {
        int len;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[10240];
        while ((len = in.read(buf)) != -1) {
            out.write(buf, 0, len);
        }
        if (enc == null) {
            return out.toString();
        }
        return out.toString(enc);
    }

    public static List<String> getStrings(InputStream in, String regex) throws IOException {
        return IOUtils.getStrings(in, regex, null);
    }

    public static List<String> getStrings(InputStream in, String regex, String enc) throws IOException {
        String line;
        ArrayList<String> strs = new ArrayList<String>();
        BufferedReader bfIn = enc == null ? new BufferedReader(new InputStreamReader(in)) : new BufferedReader(new InputStreamReader(in, enc));
        Pattern p = Pattern.compile(regex);
        while ((line = bfIn.readLine()) != null) {
            Matcher m = p.matcher(line);
            while (m.find()) {
                strs.add(m.group());
            }
        }
        return strs;
    }
}

