/*
 * Decompiled with CFR 0.152.
 */
package cn.wandersnail.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MathUtils {
    public static double setDoubleAccuracy(double num, int scale) {
        return (double)((int)(num * Math.pow(10.0, scale))) / Math.pow(10.0, scale);
    }

    public static float[] getPercents(int scale, float ... values) {
        float total = 0.0f;
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != 0.0f) {
                list.add(i);
            }
            total += values[i];
        }
        if (total == 0.0f) {
            return new float[values.length];
        }
        float[] fs = new float[values.length];
        int sc = (int)Math.pow(10.0, scale + 2);
        float sum = 0.0f;
        for (int i = 0; i < list.size(); ++i) {
            int index = (Integer)list.get(i);
            if (i == list.size() - 1) {
                fs[index] = 1.0f - sum;
                continue;
            }
            fs[index] = (float)((int)(values[index] / total * (float)sc)) / (float)sc;
            sum += fs[index];
        }
        return fs;
    }

    public static byte[] numberToBytes(boolean bigEndian, long value, int len) {
        byte[] bytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            int j = bigEndian ? 7 - i : i;
            bytes[i] = (byte)(value >> 8 * j & 0xFFL);
        }
        if (len > 8) {
            return bytes;
        }
        return Arrays.copyOfRange(bytes, bigEndian ? 8 - len : 0, bigEndian ? 8 : len);
    }

    public static <T> T bytesToNumber(boolean bigEndian, Class<T> cls, byte ... src) {
        int len = Math.min(8, src.length);
        byte[] bs = new byte[8];
        System.arraycopy(src, 0, bs, bigEndian ? 8 - len : 0, len);
        long value = 0L;
        for (int i = 0; i < 8; ++i) {
            int shift = (bigEndian ? 7 - i : i) << 3;
            value |= 255L << shift & (long)bs[i] << shift;
        }
        if (src.length == 1) {
            value = (byte)value;
        } else if (src.length == 2) {
            value = (short)value;
        } else if (src.length <= 4) {
            value = (int)value;
        }
        if (cls == Short.TYPE || cls == Short.class) {
            return (T)Short.valueOf((short)value);
        }
        if (cls == Integer.TYPE || cls == Integer.class) {
            return (T)Integer.valueOf((int)value);
        }
        if (cls == Long.TYPE || cls == Long.class) {
            return (T)Long.valueOf(value);
        }
        throw new IllegalArgumentException("cls must be one of short, int and long");
    }

    public static byte[] reverseBitAndByte(byte[] src) {
        if (src == null || src.length == 0) {
            return null;
        }
        byte[] target = new byte[src.length];
        for (int i = 0; i < src.length; ++i) {
            int value = 0;
            int tmp = src[src.length - 1 - i];
            for (int j = 7; j >= 0; --j) {
                value |= (tmp & 1) << j;
                tmp >>= 1;
            }
            target[i] = (byte)value;
        }
        return target;
    }

    public static List<byte[]> splitPackage(byte[] src, int size) {
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        int loop = src.length / size + (src.length % size == 0 ? 0 : 1);
        for (int i = 0; i < loop; ++i) {
            int from = i * size;
            int to = Math.min(src.length, from + size);
            list.add(Arrays.copyOfRange(src, i * size, to));
        }
        return list;
    }

    public static byte[] joinPackage(byte[] ... src) {
        byte[] bytes = new byte[]{};
        for (byte[] bs : src) {
            bytes = Arrays.copyOf(bytes, bytes.length + bs.length);
            System.arraycopy(bs, 0, bytes, bytes.length - bs.length, bs.length);
        }
        return bytes;
    }

    public static int calcCRC16_Modbus(byte[] data) {
        int crc = 65535;
        for (byte b : data) {
            crc = b < 0 ? (crc ^= b + 256) : (crc ^= b);
            for (int i = 8; i != 0; --i) {
                if ((crc & 1) != 0) {
                    crc >>= 1;
                    crc ^= 0xA001;
                    continue;
                }
                crc >>= 1;
            }
        }
        return crc;
    }

    public static int calcCRC_CCITT_XModem(byte[] bytes) {
        int crc = 0;
        return MathUtils.calcCrc(bytes, crc);
    }

    public static int calcCRC_CCITT_XModem(byte[] bytes, int offset, int len) {
        int crc = 0;
        return MathUtils.calcCrc(bytes, offset, len, crc);
    }

    public static int calcCRC_CCITT_0xFFFF(byte[] bytes) {
        return MathUtils.calcCrc(bytes, 65535);
    }

    private static int calcCrc(byte[] bytes, int initCrc) {
        int polynomial = 4129;
        for (byte b : bytes) {
            for (int i = 0; i < 8; ++i) {
                boolean bit = (b >> 7 - i & 1) == 1;
                boolean c15 = (initCrc >> 15 & 1) == 1;
                initCrc <<= 1;
                if (!(c15 ^ bit)) continue;
                initCrc ^= polynomial;
            }
        }
        return initCrc &= 0xFFFF;
    }

    public static int calcCRC_CCITT_0xFFFF(byte[] bytes, int offset, int len) {
        int crc = 65535;
        return MathUtils.calcCrc(bytes, offset, len, 65535);
    }

    private static int calcCrc(byte[] bytes, int offset, int len, int initCrc) {
        int polynomial = 4129;
        for (int i = offset; i < offset + len; ++i) {
            byte b = bytes[i];
            for (int j = 0; j < 8; ++j) {
                boolean bit = (b >> 7 - j & 1) == 1;
                boolean c15 = (initCrc >> 15 & 1) == 1;
                initCrc <<= 1;
                if (!(c15 ^ bit)) continue;
                initCrc ^= polynomial;
            }
        }
        return initCrc &= 0xFFFF;
    }
}

