/*
 * Decompiled with CFR 0.152.
 */
package cn.wandersnail.common.http;

import cn.wandersnail.common.http.Configuration;
import cn.wandersnail.common.http.EasyHttp;
import cn.wandersnail.common.http.callback.RequestCallback;
import cn.wandersnail.common.http.util.SchedulerUtils;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.TimeoutException;
import okhttp3.ResponseBody;
import retrofit2.Converter;
import retrofit2.Response;

class GeneralRequestTask<T> {
    Disposable disposable;

    GeneralRequestTask(Observable<Response<ResponseBody>> observable, Converter<ResponseBody, T> converter, Configuration configuration, RequestCallback<T> callback) {
        if (configuration.callTimeout > 0) {
            EasyHttp.executorService.execute(() -> {
                try {
                    Thread.sleep(configuration.callTimeout);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                GeneralRequestTask generalRequestTask = this;
                synchronized (generalRequestTask) {
                    if (this.disposable != null && !this.disposable.isDisposed()) {
                        this.disposable.dispose();
                    }
                    this.disposable = null;
                    if (callback != null) {
                        callback.onError(new TimeoutException("Http request timeout!"));
                    }
                }
            });
        }
        this.disposable = observable.compose(SchedulerUtils.applyGeneralObservableSchedulers()).subscribe(response -> {
            this.disposable = null;
            if (callback != null) {
                try {
                    ResponseBody body = (ResponseBody)response.body();
                    callback.onSuccess((Response<ResponseBody>)response, body == null ? null : (converter == null ? body : converter.convert((Object)body)));
                }
                catch (Throwable t) {
                    callback.onError(t);
                    callback.onSuccess((Response<ResponseBody>)response, null);
                }
            }
        }, throwable -> {
            this.disposable = null;
            if (callback != null) {
                callback.onError((Throwable)throwable);
            }
        }, () -> {
            this.disposable = null;
        });
    }

    Disposable getDisposable() {
        return this.disposable;
    }
}

