/*
 * Decompiled with CFR 0.152.
 */
package cn.wandersnail.common.http;

import cn.wandersnail.common.http.Configuration;
import cn.wandersnail.common.http.ConvertedResponse;
import cn.wandersnail.common.http.Requester;
import cn.wandersnail.common.http.callback.RequestCallback;
import io.reactivex.disposables.Disposable;
import java.util.HashMap;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Converter;

public class PostRequester<T>
extends Requester<T> {
    private RequestBody body;
    private Map<String, Object> params;
    private boolean isJsonBody;

    public PostRequester<T> setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public PostRequester<T> setUrl(String url) {
        this.url = url;
        return this;
    }

    public PostRequester<T> setConverter(Converter<ResponseBody, T> converter) {
        this.converter = converter;
        return this;
    }

    public PostRequester<T> setTextBody(String text) {
        this.body = RequestBody.create((MediaType)MediaType.parse((String)"text/plain;charset=utf-8"), (String)text);
        return this;
    }

    public PostRequester<T> setJsonBody(String json) {
        this.body = RequestBody.create((MediaType)MediaType.parse((String)"application/json;charset=utf-8"), (String)json);
        this.isJsonBody = true;
        return this;
    }

    public PostRequester<T> setBody(RequestBody body) {
        this.body = body;
        return this;
    }

    public PostRequester<T> setParams(Map<String, Object> params) {
        this.params = params;
        return this;
    }

    @Override
    public ConvertedResponse<T> execute() {
        this.handleConfiguration(this.url, this.configuration);
        if (this.isJsonBody) {
            if (this.configuration.headers == null) {
                this.configuration.headers = new HashMap<String, String>();
            }
            this.configuration.headers.put("Content-Type", "application/json;charset=utf-8");
            this.configuration.headers.put("Accept", "application/json;");
        }
        if (this.configuration.headers != null && !this.configuration.headers.isEmpty()) {
            if (this.params != null) {
                if (this.body != null) {
                    return this.execute(this.configuration.service.postSync(this.url, this.configuration.headers, this.params, this.body));
                }
                return this.execute(this.configuration.service.postFormSync(this.url, this.configuration.headers, this.params));
            }
            if (this.body != null) {
                return this.execute(this.configuration.service.postSync(this.url, this.configuration.headers, this.body));
            }
            return this.execute(this.configuration.service.postSync(this.url, this.configuration.headers));
        }
        if (this.params != null) {
            if (this.body != null) {
                return this.execute(this.configuration.service.postParamsAndBodySync(this.url, this.params, this.body));
            }
            return this.execute(this.configuration.service.postFormSync(this.url, this.params));
        }
        if (this.body != null) {
            return this.execute(this.configuration.service.postSync(this.url, this.body));
        }
        return this.execute(this.configuration.service.postSync(this.url));
    }

    @Override
    public Disposable enqueue(RequestCallback<T> callback) {
        this.handleConfiguration(this.url, this.configuration);
        if (this.isJsonBody) {
            if (this.configuration.headers == null) {
                this.configuration.headers = new HashMap<String, String>();
            }
            this.configuration.headers.put("Content-Type", "application/json;charset=utf-8");
            this.configuration.headers.put("Accept", "application/json;");
        }
        if (this.configuration.headers != null && !this.configuration.headers.isEmpty()) {
            if (this.params != null) {
                if (this.body != null) {
                    return this.enqueue(this.configuration.service.post(this.url, this.configuration.headers, this.params, this.body), callback);
                }
                return this.enqueue(this.configuration.service.postForm(this.url, this.configuration.headers, this.params), callback);
            }
            if (this.body != null) {
                return this.enqueue(this.configuration.service.post(this.url, this.configuration.headers, this.body), callback);
            }
            return this.enqueue(this.configuration.service.post(this.url, this.configuration.headers), callback);
        }
        if (this.params != null) {
            if (this.body != null) {
                return this.enqueue(this.configuration.service.postParamsAndBody(this.url, this.params, this.body), callback);
            }
            return this.enqueue(this.configuration.service.postForm(this.url, this.params), callback);
        }
        if (this.body != null) {
            return this.enqueue(this.configuration.service.post(this.url, this.body), callback);
        }
        return this.enqueue(this.configuration.service.post(this.url), callback);
    }
}

