/*
 * Decompiled with CFR 0.152.
 */
package cn.wandersnail.common.http.download;

import cn.wandersnail.common.http.TaskInfo;
import cn.wandersnail.common.http.callback.ProgressListener;
import cn.wandersnail.common.http.download.DownloadInfo;
import cn.wandersnail.common.http.download.DownloadListener;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;

class DownloadObserver<T extends DownloadInfo>
implements Observer<Response<ResponseBody>>,
ProgressListener {
    private static final int UPDATE_LIMIT_DURATION = 500;
    private final T info;
    private final DownloadListener<T> listener;
    private Disposable disposable;
    private long lastUpdateTime;

    DownloadObserver(T info, DownloadListener<T> listener) {
        this.info = info;
        this.listener = listener;
    }

    @Override
    public void onProgress(long progress, long max) {
        Schedulers.io().scheduleDirect(() -> {
            long completionLength = progress;
            if (((DownloadInfo)this.info).contentLength > max) {
                completionLength += ((DownloadInfo)this.info).contentLength - max;
            } else {
                ((DownloadInfo)this.info).contentLength = max;
            }
            ((DownloadInfo)this.info).completionLength = completionLength;
            if (System.currentTimeMillis() - this.lastUpdateTime >= 500L && (((DownloadInfo)this.info).state == TaskInfo.State.IDLE || ((DownloadInfo)this.info).state == TaskInfo.State.START || ((DownloadInfo)this.info).state == TaskInfo.State.ONGOING)) {
                if (((DownloadInfo)this.info).state != TaskInfo.State.ONGOING) {
                    ((DownloadInfo)this.info).state = TaskInfo.State.ONGOING;
                    if (this.listener != null) {
                        this.listener.onStateChange(this.info, null);
                    }
                }
                this.updateProgress();
                this.lastUpdateTime = System.currentTimeMillis();
            }
        });
    }

    public void onSubscribe(Disposable d) {
        this.disposable = d;
        ((DownloadInfo)this.info).state = TaskInfo.State.START;
        if (this.listener != null) {
            this.listener.onStateChange(this.info, null);
        }
    }

    public void onNext(Response<ResponseBody> responseBodyResponse) {
    }

    public void onError(Throwable e) {
        this.disposable = null;
        ((DownloadInfo)this.info).state = TaskInfo.State.ERROR;
        if (this.listener != null) {
            this.listener.onStateChange(this.info, e);
        }
    }

    public void onComplete() {
        this.disposable = null;
        Schedulers.io().scheduleDirect(() -> {
            boolean success;
            File destFile = new File(((DownloadInfo)this.info).savePath);
            File parentFile = destFile.getParentFile();
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            if (destFile.exists()) {
                destFile.delete();
            }
            File tempFile = ((DownloadInfo)this.info).getTemporaryFile();
            this.copyFile(tempFile, destFile);
            boolean bl = success = destFile.exists() && tempFile.length() == destFile.length();
            if (!success) {
                destFile.delete();
            }
            tempFile.delete();
            Schedulers.io().scheduleDirect(() -> {
                if (success) {
                    ((DownloadInfo)this.info).completionLength = ((DownloadInfo)this.info).contentLength;
                    this.updateProgress();
                    ((DownloadInfo)this.info).state = TaskInfo.State.COMPLETED;
                    if (this.listener != null) {
                        this.listener.onStateChange(this.info, null);
                    }
                } else {
                    ((DownloadInfo)this.info).state = TaskInfo.State.ERROR;
                    if (this.listener != null) {
                        this.listener.onStateChange(this.info, new Throwable("Renaming to target file failed"));
                    }
                }
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File src, File target) {
        BufferedInputStream fis = null;
        BufferedOutputStream fos = null;
        try {
            int len;
            fis = new BufferedInputStream(new FileInputStream(src));
            fos = new BufferedOutputStream(new FileOutputStream(target));
            byte[] buffer = new byte[40960];
            while ((len = fis.read(buffer)) != -1) {
                fos.write(buffer, 0, len);
            }
            fos.flush();
        }
        catch (Exception e) {
            try {
                target.delete();
            }
            catch (Throwable throwable) {
                this.closeQuietly(fis, fos);
                throw throwable;
            }
            this.closeQuietly(fis, fos);
        }
        this.closeQuietly(fis, fos);
    }

    private void closeQuietly(Closeable ... closeables) {
        try {
            if (closeables != null) {
                for (Closeable closeable : closeables) {
                    if (closeable == null) continue;
                    closeable.close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void updateProgress() {
        if (((DownloadInfo)this.info).completionLength > 0L && ((DownloadInfo)this.info).contentLength > 0L && this.listener != null) {
            this.listener.onProgress(this.info);
        }
    }

    public void dispose(boolean cancel) {
        Schedulers.io().scheduleDirect(() -> {
            if (this.disposable != null && !this.disposable.isDisposed()) {
                this.disposable.dispose();
            }
            if (((DownloadInfo)this.info).state == TaskInfo.State.ONGOING || ((DownloadInfo)this.info).state == TaskInfo.State.START) {
                if (cancel) {
                    ((DownloadInfo)this.info).state = TaskInfo.State.CANCEL;
                    ((DownloadInfo)this.info).getTemporaryFile().delete();
                } else {
                    ((DownloadInfo)this.info).state = TaskInfo.State.PAUSE;
                }
                if (this.listener != null) {
                    this.listener.onStateChange(this.info, null);
                }
            }
        });
    }
}

