/*
 * Decompiled with CFR 0.152.
 */
package cn.wandersnail.common.http.download;

import cn.wandersnail.common.http.TaskInfo;
import cn.wandersnail.common.http.download.DownloadInfo;
import cn.wandersnail.common.http.download.DownloadListener;
import cn.wandersnail.common.http.download.DownloadObserver;
import cn.wandersnail.common.http.download.DownloadService;
import cn.wandersnail.common.http.download.MultiDownloadListener;
import cn.wandersnail.common.http.download.ProgressInterceptor;
import cn.wandersnail.common.http.exception.RetryWhenException;
import cn.wandersnail.common.http.util.HttpUtils;
import cn.wandersnail.common.http.util.SchedulerUtils;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Function;
import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import retrofit2.CallAdapter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;

public class DownloadWorker<T extends DownloadInfo>
implements Disposable {
    private final Map<T, DownloadObserver<T>> taskMap = new ConcurrentHashMap<T, DownloadObserver<T>>();
    private final DownloadListener<T> listener;
    private int successNum;
    private int failureNum;
    private boolean isCanceled;
    private final int taskCount;

    public DownloadWorker(T info, DownloadListener<T> listener) {
        this.listener = listener;
        this.taskCount = 1;
        ((DownloadInfo)info).reset();
        this.execute(info);
    }

    public DownloadWorker(List<T> infoList, MultiDownloadListener<T> listener) {
        this.listener = listener;
        this.taskCount = infoList.size();
        for (DownloadInfo info : infoList) {
            info.reset();
            this.execute(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(T info) {
        DownloadObserver<T> observer = new DownloadObserver<T>(info, this.listener == null ? null : new LocalTaskListener());
        DownloadWorker downloadWorker = this;
        synchronized (downloadWorker) {
            this.taskMap.put(info, observer);
        }
        OkHttpClient httpClient = HttpUtils.initHttpsClient(true, new OkHttpClient.Builder()).addInterceptor((Interceptor)new ProgressInterceptor(observer)).build();
        ((DownloadService)new Retrofit.Builder().client(httpClient).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).baseUrl(((TaskInfo)info).getBaseUrl()).build().create(DownloadService.class)).download("bytes=" + ((DownloadInfo)info).completionLength + "-", ((DownloadInfo)info).url).retryWhen((Function)new RetryWhenException()).map(responseBodyResponse -> {
            this.writeToDisk((ResponseBody)responseBodyResponse.body(), info.getTemporaryFile(), info);
            return responseBodyResponse;
        }).compose(SchedulerUtils.applyGeneralObservableSchedulers()).subscribe(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToDisk(ResponseBody body, File file, T info) {
        if (body == null) {
            return;
        }
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        InputStream input = body.byteStream();
        long allLen = ((DownloadInfo)info).contentLength == 0L ? body.contentLength() : ((DownloadInfo)info).contentLength;
        RandomAccessFile accessFile = null;
        FileChannel channel = null;
        try {
            int len;
            accessFile = new RandomAccessFile(file, "rwd");
            channel = accessFile.getChannel();
            MappedByteBuffer byteBuffer = channel.map(FileChannel.MapMode.READ_WRITE, ((DownloadInfo)info).completionLength, allLen - ((DownloadInfo)info).completionLength);
            byte[] buffer = new byte[10240];
            while ((len = input.read(buffer)) != -1) {
                byteBuffer.put(buffer, 0, len);
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                HttpUtils.closeQuietly(channel, accessFile, input);
                throw throwable;
            }
            HttpUtils.closeQuietly(channel, accessFile, input);
        }
        HttpUtils.closeQuietly(channel, accessFile, input);
    }

    public void dispose() {
        this.cancel();
    }

    public boolean isDisposed() {
        return false;
    }

    public synchronized void cancel(T info) {
        DownloadObserver<T> observer = this.taskMap.remove(info);
        if (observer != null) {
            observer.dispose(true);
            if (this.taskMap.isEmpty()) {
                this.isCanceled = true;
            }
        }
    }

    public synchronized void cancel() {
        if (!this.taskMap.isEmpty()) {
            for (DownloadObserver<T> observer : this.taskMap.values()) {
                observer.dispose(true);
            }
            this.taskMap.clear();
            this.isCanceled = true;
        }
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public int remaining() {
        return this.taskMap.size();
    }

    public boolean isOngoing() {
        return this.remaining() > 0;
    }

    public synchronized void resume(T info) {
        if (((DownloadInfo)info).state == TaskInfo.State.PAUSE) {
            this.execute(info);
        }
    }

    public synchronized void resume() {
        for (DownloadInfo t : this.taskMap.keySet()) {
            if (t.state != TaskInfo.State.PAUSE) continue;
            this.execute(t);
        }
    }

    public synchronized void pause(T info) {
        DownloadObserver<T> observer = this.taskMap.get(info);
        if (observer != null) {
            observer.dispose(false);
        }
    }

    public synchronized void pause() {
        for (DownloadObserver<T> observer : this.taskMap.values()) {
            observer.dispose(false);
        }
    }

    private class LocalTaskListener
    implements DownloadListener<T> {
        private LocalTaskListener() {
        }

        @Override
        public void onStateChange(T info, Throwable t) {
            if (DownloadWorker.this.listener != null) {
                DownloadWorker.this.listener.onStateChange(info, t);
            }
            if (((DownloadInfo)info).state == TaskInfo.State.COMPLETED) {
                DownloadWorker.this.taskMap.remove(info);
                DownloadWorker.this.successNum++;
            } else if (((DownloadInfo)info).state == TaskInfo.State.CANCEL || ((DownloadInfo)info).state == TaskInfo.State.ERROR) {
                DownloadWorker.this.taskMap.remove(info);
                DownloadWorker.this.failureNum++;
            } else if (((DownloadInfo)info).state != TaskInfo.State.START) {
                return;
            }
            if (DownloadWorker.this.listener instanceof MultiDownloadListener) {
                ((MultiDownloadListener)DownloadWorker.this.listener).onTotalProgress(DownloadWorker.this.successNum, DownloadWorker.this.failureNum, DownloadWorker.this.taskCount);
            }
        }

        @Override
        public void onProgress(T info) {
            if (DownloadWorker.this.listener != null) {
                DownloadWorker.this.listener.onProgress(info);
            }
        }
    }
}

