/*
 * Decompiled with CFR 0.152.
 */
package cn.wandersnail.common.http.upload;

import cn.wandersnail.common.http.upload.UploadProgressListener;
import cn.wandersnail.common.http.util.HttpUtils;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;

class ProgressRequestBody
extends RequestBody {
    private final MediaType contentType;
    private final String filename;
    private final InputStream inputStream;
    private final UploadProgressListener listener;

    ProgressRequestBody(MediaType contentType, String filename, InputStream inputStream, UploadProgressListener listener) {
        this.contentType = contentType;
        this.filename = filename;
        this.inputStream = inputStream;
        this.listener = listener;
    }

    public MediaType contentType() {
        return this.contentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(BufferedSink sink) throws IOException {
        long uploadCount = 0L;
        try {
            int len;
            byte[] buffer = new byte[10240];
            while ((len = this.inputStream.read(buffer)) != -1) {
                sink.write(buffer, 0, len);
                uploadCount += (long)len;
                if (this.listener == null) continue;
                this.listener.onProgress(this.filename, uploadCount, this.contentLength());
            }
        }
        catch (Throwable throwable) {
            HttpUtils.closeQuietly(this.inputStream);
            throw throwable;
        }
        HttpUtils.closeQuietly(this.inputStream);
    }
}

