/*
 * Decompiled with CFR 0.152.
 */
package cn.wandersnail.common.http.upload;

import cn.wandersnail.common.http.ConvertedResponse;
import cn.wandersnail.common.http.upload.FileInfo;
import cn.wandersnail.common.http.upload.ProgressRequestBody;
import cn.wandersnail.common.http.upload.UploadInfo;
import cn.wandersnail.common.http.upload.UploadProgressListener;
import cn.wandersnail.common.http.upload.UploadService;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;

public class SyncUploadWorker<T> {
    public ConvertedResponse<T> convertedResp;

    /*
     * WARNING - void declaration
     */
    public SyncUploadWorker(UploadInfo<T> info, UploadProgressListener listener) {
        void var7_11;
        Retrofit.Builder builder = new Retrofit.Builder();
        if (info.client != null) {
            builder.client(info.client);
        }
        UploadService service = (UploadService)builder.addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).baseUrl(info.getBaseUrl()).build().create(UploadService.class);
        MultipartBody.Builder bodyBuilder = new MultipartBody.Builder();
        if (info.paramParts != null) {
            for (Map.Entry<String, String> entry : info.paramParts.entrySet()) {
                bodyBuilder.addFormDataPart(entry.getKey(), entry.getValue());
            }
        }
        UploadProgressListener localListener = (name, progress, max) -> {
            if (listener != null) {
                listener.onProgress(name, progress, max);
            }
        };
        for (FileInfo fileInfo : info.fileInfos) {
            try {
                MultipartBody.Part part = MultipartBody.Part.createFormData((String)fileInfo.getFromDataName(), (String)URLEncoder.encode(fileInfo.getFilename(), "utf-8"), (RequestBody)new ProgressRequestBody(MediaType.parse((String)"multipart/form-data"), fileInfo.getFilename(), fileInfo.getInputStream(), localListener));
                bodyBuilder.addPart(part);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        if (info.headers == null || info.headers.isEmpty()) {
            Call<ResponseBody> call = service.uploadSync(info.url, bodyBuilder.build());
        } else {
            Call<ResponseBody> call = service.uploadSync(info.url, bodyBuilder.build(), info.headers);
        }
        this.convertedResp = new ConvertedResponse((Call<ResponseBody>)var7_11);
        try {
            Response response;
            this.convertedResp.response = response = var7_11.execute();
            if (response.isSuccessful() && info.converter != null && response.body() != null) {
                try {
                    this.convertedResp.convertedResponse = info.converter.convert(response.body());
                }
                catch (Throwable t) {
                    this.convertedResp.convertError = t;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

