/*
 * Decompiled with CFR 0.152.
 */
package cn.wandersnail.common.http.upload;

import cn.wandersnail.common.http.TaskInfo;
import cn.wandersnail.common.http.upload.UploadInfo;
import cn.wandersnail.common.http.upload.UploadListener;
import cn.wandersnail.common.http.upload.UploadProgressListener;
import io.reactivex.Observer;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;
import java.util.HashMap;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;

class UploadObserver<T>
implements Observer<Response<ResponseBody>>,
Disposable,
UploadProgressListener {
    private static final int UPDATE_LIMIT_DURATION = 500;
    private final UploadInfo<T> info;
    private final UploadListener<T> listener;
    private Disposable disposable;
    private long lastUpdateTime;
    private final Map<String, Long> contentLengthMap = new HashMap<String, Long>();

    UploadObserver(@NonNull UploadInfo<T> info, UploadListener<T> listener) {
        this.info = info;
        this.listener = listener;
    }

    @Override
    public void onProgress(String filename, long progress, long max) {
        Schedulers.io().scheduleDirect(() -> {
            long completionLength = progress;
            Long contentLen = this.contentLengthMap.get(filename);
            if (contentLen != null && contentLen > max) {
                completionLength += contentLen - max;
            } else {
                this.contentLengthMap.put(filename, max);
                contentLen = max;
            }
            if (System.currentTimeMillis() - this.lastUpdateTime >= 500L && (this.info.state == TaskInfo.State.IDLE || this.info.state == TaskInfo.State.START || this.info.state == TaskInfo.State.ONGOING)) {
                if (this.info.state != TaskInfo.State.ONGOING) {
                    this.info.state = TaskInfo.State.ONGOING;
                    if (this.listener != null) {
                        this.listener.onStateChange(this.info.state, null);
                    }
                }
                if (this.listener != null) {
                    this.listener.onProgress(filename, completionLength, contentLen);
                }
                this.lastUpdateTime = System.currentTimeMillis();
            }
        });
    }

    public void onSubscribe(Disposable d) {
        this.disposable = d;
        this.info.state = TaskInfo.State.START;
        if (this.listener != null) {
            this.listener.onStateChange(this.info.state, null);
        }
    }

    public void onNext(Response<ResponseBody> response) {
        if (this.listener != null) {
            if (this.info.converter != null) {
                try {
                    Object convertedBody = this.info.converter.convert(response.body());
                    this.listener.onResponseBodyParse(response, convertedBody);
                }
                catch (Exception e) {
                    this.listener.onConvertError(e);
                    this.listener.onResponseBodyParse(response, null);
                }
            } else {
                this.listener.onResponseBodyParse(response, null);
            }
        }
    }

    public void onError(Throwable e) {
        this.disposable = null;
        this.info.state = TaskInfo.State.ERROR;
        if (this.listener != null) {
            this.listener.onStateChange(this.info.state, e);
        }
    }

    public void onComplete() {
        this.disposable = null;
        if (this.listener != null) {
            for (Map.Entry<String, Long> entry : this.contentLengthMap.entrySet()) {
                this.listener.onProgress(entry.getKey(), entry.getValue(), entry.getValue());
            }
        }
        this.info.state = TaskInfo.State.COMPLETED;
        if (this.listener != null) {
            this.listener.onStateChange(this.info.state, null);
        }
    }

    public void dispose() {
        Schedulers.io().scheduleDirect(() -> {
            if (!this.isDisposed()) {
                this.disposable.dispose();
            }
            if (this.info.state == TaskInfo.State.ONGOING || this.info.state == TaskInfo.State.START) {
                this.info.state = TaskInfo.State.CANCEL;
                if (this.listener != null) {
                    this.listener.onStateChange(this.info.state, null);
                }
            }
        });
    }

    public boolean isDisposed() {
        return this.disposable == null || this.disposable.isDisposed();
    }
}

